# This file includes macro definitions for GURPS.

# Note: you must define PLUGIN before including this file, either as
# nothing or a plugin identifier.

$$define	AddRaceAsList	

$$macro defineSyms(dummy)
{{
$$if(fileExists(getSourceDir(0), "GURPSCustom.inc"))
	$$include GURPSCustom.inc
$$endif
}}

$$defineSyms()

# Argument type definintions: used to define how arguments are edited
# in macro data sheets.

$$define spcolls Acid|Air|Animal|Body Control|Communication and Empathy|Earth|Electricity|Enchantment|Energy|Fire|Food|Gate|Healing|Ice|Illusion and Creation|Knowledge|Light and Darkness|Machine|Making and Breaking|Meta-Spell|Metal/Plastic|Mind Control|Movement|Necromantic|Plant|Protection and Warning|Radiation|Sound|Technological|Water|Weather

$$argtype(skilldiff, choose, "Choose Difficulty",
	"To prevent a mental skill from being affected by IQ use \"!\": MH!.\r\n\
To base the skill on a different attribute use a slash and the attribute: MA/HT.",
	"MH|MVH|MA|ME|PA|PE|PH|*")

$$argtype(spellcat, list, "Spell Colleges",
	"Select one or more spell colleges", ";", "$(spcolls)|*")

$$argtype(colleges, list, "Spell Colleges", 
	"Select the names of other colleges that include the spell.",
	", ", "$(spcolls)|*")

$$argtype(spellclass, choose, "Spell Class",
	"Select the spell class.", 
	"Regular|Area|Missile|Blocking|Information|Resisted|Enchantment|Special|*")

$$argtype(attribute, choose, "Attribute", "Select an attribute", "IQ|DX|HT|ST")

$$argtype(suppowtype, choose, "Super Power Type", 
	"Select the type RM (Ranged/Mental), AP (Area/Physical), SM (Special/Mental), etc.",
	"RM|RP|AM|AP|SP|SM")

$$argtype(attribute, choose, "Attribute", "Select the attribute", "ST|DX|IQ|HT")

$$argtype(bodyparts, list, "Select Parts Protected",
	"Double-click the parts of the body protected by the armor.",
	",", "Head|Arms|Legs|Body|Hands|Feet|Whole")

$$argtype(mmdiff, choose, "Maneuver Difficulty", "Select maneuver difficulty.",  "Avg|Hard")

# Macros used for item definitions.

$$define equiptcf (c+a)*m+aux

$$macro item(name)
{{
	item "$(name)"
	$$ifdef(PLUGIN) dsid "$(PLUGIN)" $$endif
}}

# Advantage macros


$$macro ladv(name, cl, adj, formula, checkexp, prereq, cat, varname, format, initlevel, levfmt, tcf, sformat) {{
$$macrodesc("Level-based advantage/disadvantage")
$$argdesc(name, "Advantage name")
$$argdesc(cl, "Cost per level: a number, or number/unit (optional)")
$$argdesc(adj: adjustment, "Adjustments (optional)")
$$argdesc(formula, "Formula (optional, default is ~x*$(cl)")
$$argdesc(checkexp, "Check expression (optional, default is \"x>0 and x>=&x\")")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(cat: category, "Categories (optional, separated by semicolons)")
$$argdesc(varname, "Variable name (optional)")
$$argdesc(format, "Display format (optional)")
$$argdesc(initlevel, "Initial level (optional, default is 1)")
$$argdesc(levfmt, "Selection format (optional, default is ^v)")
$$argdesc(tcf, "Total cost formula (optional)")
$$argdesc(sformat, "Selection format (optional, default is ^n)")

	$$item($(name))
	$$ifdef(cat) cat "$(cat)" $$endif
	$$ifdef(varname) 
		varname "$(varname)" 
	$$else
		varname "$$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")"
	$$endif
	noviolation

	$$ifdef(initlevel)
		level "$(initlevel)"
	$$else
		level 1
	$$endif

	$$ifdef(format)
		format "$(format)"
	$$else
		format "%0ln%-14rx'displev(@c@)'$$ifdef(levfmt)%-7r!$(levfmt)$$else%-7rv$$endif"
	$$endif

	$$ifdef(formula)
		sformat "%0l$$ifnull(sformat)n$$else!$(sformat)$$endif%-15r!$(cl)"
		formula "$(formula)"
	$$else
		$$scan(cl, "(.+)/(.+)|(.+)", cplev, unit)
		sformat "%0l$$ifnull(sformat)n$$else!$(sformat)$$endif%-15r!$(cplev)/$$ifnull(unit)level$$else$(unit)$$endif"
		formula "~x*$(cplev)"
	$$endif

	$$ifdef(tcf)
		totalcostformula "$(tcf)"
	$$else
		totalcostformula "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"
	$$endif

	$$ifdef (checkexp)
		checkexp "$(checkexp)"
	$$else
		checkexp "x>0 and x>=&x"
	$$endif
	noviolation

	$$ifdef (adj) adj $(adj) $$endif
	$$ifdef (prereq) prereq "$(prereq)" $$endif
}}


# Macro for named level-based advantages

$$macro nadv(name, adj, lookup, formula, checkexp, prereq, cat, varname, format, tcf, sformat) {{
$$macrodesc("Named level-based advantage macro")
$$argdesc(name, "Name of advantage")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(lookup, "The lookup array (press SHIFT+F1 for more).")
$$argdesc(formula, "Cost formula (optional)")
$$argdesc(checkexp, "Check expression (optional)")
$$argdesc(prereq: req, "Prerequisities (optional)")
$$argdesc(cat: cat, "Category (optional, multiples separated by semicolons)")
$$argdesc(varname, "Variable name (optional)")
$$argdesc(format, "Display format (optional)")
$$argdesc(tcf, "Total cost formula (optional)")
$$argdesc(sformat, "Selection format (optional, default is ^n)")

	$$ifdef(format)
		$$ladv($(name), Variable, $(adj), $(formula), $(checkexp), $(prereq), $(cat), $(varname), $(format), , , $(tcf), $(sformat))
	$$else
		$$ladv($(name), Variable, $(adj), $(formula), $(checkexp), $(prereq), $(cat), $(varname), "%0ln%-14rc%-7r!", , , $(tcf), $(sformat))
	$$endif
	lookupArray "$(lookup)"
	checkmsg "Value not allowed."
}}


# Macro for constant advantages.

$$macro cadv(name, cost, prereq, cat, fcost, adj, format, sformat, tcf) {{
$$macrodesc("Constant cost advantage macro")
$$argdesc(name, "Name of advantage")
$$argdesc(cost, "Advantage cost")
$$argdesc(prereq: req, "Prerequisities (optional)")
$$argdesc(adj: adj, "Adjustments (optiona)")
$$argdesc(fcost, "Obsolete argument (omit)")
$$argdesc(cat: cat, "Category (optional, multiples separated by semicolons)")
$$argdesc(format, "Display format (optional)")
$$argdesc(sformat, "Selection format (optional)")
$$argdesc(tcf, "Total cost formula")

	$$item($(name))
	noviolation
	$$ifnull(cost) $$error(Cost missing in cadv macro) $$endif

	cost "$(cost)"
	keepcost
	#formula "x"
	#level "$(cost)"
	#checkexp "x=$(cost)"
	$$ifdef(format)
		format "%0l!$(format)%-14rc%-7r! "
	$$else
		format "%0ln%-14rc%-7r! "
	$$endif
	$$ifdef(tcf)
		totalcostformula "`No Cost`?0:($(tcf))"
	$$else
		totalcostformula "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"
	$$endif
	$$ifdef(sformat) 
		sformat "$(sformat)"
	$$else
		sformat "%0ln%-5rc"
	$$endif
	$$ifdef(adj) adj "$(adj)" $$endif
	$$ifdef (prereq) prereq "$(prereq)" $$endif
	$$ifdef(cat) cat "$(cat)" $$endif
	editdlg 4
}}



# Appearance macro.

$$macro appadv(name, level, cost, reaction) {{
$$macrodesc("Appeance advantage")
$$argdesc(name, "Name of advantage")
$$argdesc(level, "Level of appearance (1, 2, 3)")
$$argdesc(cost, "Cost of appearance (5, 15, 25)")
$$argdesc(reaction, "Reaction adjustment (+1, +2/+4, +6)")
	$$item($(name))
	noviolation
	cost "$(cost)"
	formula "max(0,($(cost)-qindex(&x+1,0,5,15,25))*(hunchback?2:1))"
	varname appadv
	adj appearance+x
	level "$(level)"
	checkexp "x=$(level)"
	format "%0ln%-14rx'displev(@c@)'%-7r!"
	totalcostformula "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"
	sformat "%0ln%-5rc"
	prereq "!#1,Adv:Appearance::Only one Appearance allowed;!#1,Disadv:Appearance::Appearance Disadvantage not allowed"
	cat "Appearance"
	editdlg 4
	opt	
		text Reaction "$(reaction)"
		end
}}


# Appearance disadvantage macro.

$$macro appdisadv(name, level) {{
$$macrodesc("Appeance disadvantage")
$$argdesc(name, "Name of disadvantage")
$$argdesc(level, "Level of appearance (1-5)")
	$$item($(name))
	noviolation
	cost "$$exp("qindex(level,-5,-10,-20,-25,-30)")"
	formula "qindex(-x,-5,-10,-20,-25,-30)"
	varname appdisadv
	adj appearance+x
	level "-$(level)"
	checkexp "x=-$(level)"
	format "%0ln%-14rx'displev(@c@)'%-7r!"
	totalcostformula "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"
	sformat "%0ln%-5rc"
	prereq "!#1,Disadv:Appearance::Only one Appearance allowed;!#1,Adv:Appearance::Appearance advantage not allowed"
	cat "Appearance"
	editdlg 4
	opt	
		exp Reaction "integer(c/5)"
		end
}}


# Macro for constant advantages that can have a zero cost.

$$macro zcadv(name, cost, prereq, cat, fcost, adj, format, sformat, tcf, varname) {{
$$macrodesc("Macro for advantages that have a zero cost when a bonus has been assigned to its variable")
$$argdesc(name, "Name of advantage")
$$argdesc(cost, "Advantage cost")
$$argdesc(prereq: req, "Prerequisities (optional)")
$$argdesc(adj: adj, "Adjustments (optiona)")
$$argdesc(fcost, "Obsolete argument (omit)")
$$argdesc(cat: cat, "Category (optional, multiples separated by semicolons)")
$$argdesc(format, "Display format (optional)")
$$argdesc(sformat, "Selection format (optional)")
$$argdesc(tcf, "Total cost formula")
$$argdesc(varname, "Variable name (optional, default is name with non-alpha removed)")

	$$item($(name))
	noviolation
	$$ifnull(cost) $$error(Cost missing in zcadv macro) $$endif

	$$ifdef(varname)
		varname "$(varname)"
	$$else
		varname "$$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")"
	$$endif
	formula x=~x?x:0
	$$if(cost>0)
		checkexp x>=0
	$$else
		checkexp x<=0
	$$endif

	level "$(cost)"
	cost "$(cost)"

	$$ifdef(format)
		format "%0l!$(format)%-14rx'displev(@c@)'%-7r!"
	$$else
		format "%0ln%-14rx'displev(@c@)'%-7r!"
	$$endif
	$$ifdef(tcf)
		totalcostformula "`No Cost`?0:($(tcf))"
	$$else
		totalcostformula "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"
	$$endif
	$$ifdef(sformat) sformat "$(sformat)" 
	$$else sformat "%0ln%-10r!$(cost)"
	$$endif
	$$ifdef(adj) adj "$(adj)" $$endif
	$$ifdef (prereq) prereq "$(prereq)" $$endif
	$$ifdef(cat) cat "$(cat)" $$endif
	editdlg 4
}}


# Macro for constant advantages that can have a reduced cost.

$$macro rcadv(name, cost, prereq, cat, fcost, adj, format, sformat, tcf) {{
$$macrodesc("Macro for advantages that have a reduced cost when a bonus has been assigned to its variable")
$$argdesc(name, "Name of advantage")
$$argdesc(cost, "Advantage cost")
$$argdesc(prereq: req, "Prerequisities (optional)")
$$argdesc(adj: adj, "Adjustments (optiona)")
$$argdesc(fcost, "Obsolete argument (omit)")
$$argdesc(cat: cat, "Category (optional, multiples separated by semicolons)")
$$argdesc(format, "Display format (optional)")
$$argdesc(sformat, "Selection format (optional)")
$$argdesc(tcf, "Total cost formula")

	$$item($(name))
	noviolation
	$$ifnull(cost) $$error(Cost missing in rcadv macro) $$endif

	varname "$$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")"
	formula x-&x
	$$if(cost>0)
		checkexp x>=0
	$$else
		checkexp x<=0
	$$endif

	level "$(cost)"
	cost "$(cost)"

	$$ifdef(format)
		format "%0l!$(format)%-14rx'displev(@c@)'%-7r!"
	$$else
		format "%0ln%-14rx'displev(@c@)'%-7r!"
	$$endif
	$$ifdef(tcf)
		totalcostformula "`No Cost`?0:($(tcf))"
	$$else
		totalcostformula "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"
	$$endif
	$$ifdef(sformat) sformat "$(sformat)" 
	$$else sformat "%0ln%-10r!$(cost)"
	$$endif
	$$ifdef(adj) adj "$(adj)" $$endif
	$$ifdef (prereq) prereq "$(prereq)" $$endif
	$$ifdef(cat) cat "$(cat)" $$endif
	editdlg 4
}}



# Macro for fixed-level advantages

$$macro fladv(name, min, max, label, costs, prereq, cat, adj, format)
{{
$$macrodesc("Named fixed-level cost advantage macro")
$$argdesc(name, "Name of advantage")
$$argdesc(min, "Minimum cost")
$$argdesc(max, "Maximum cost")
$$argdesc(label, "Label for the option that contains the cost option")
$$argdesc(costs, "List of costs: e.g., Small,5;Medium,10;Large,15")
$$argdesc(prereq: req, "Prerequisities (optional)")
$$argdesc(adj: adj, "Adjustments (optiona)")
$$argdesc(cat: cat, "Category (optional, multiples separated by semicolons)")
$$argdesc(format, "Display format (optional)")

	$$item($(name))
	cost 0
	$$ifdef(prereq)
		prereq "$(prereq)"
	$$endif
	$$ifdef(adj) adj "$(adj)" $$endif
	$$ifdef(cat) cat "$(cat)" $$endif
	$$ifdef(format)
		format "%0l!$(format)%-14rc%-7r!"
	$$else
		format "%0ln (^o'$(label)')%-14rc%-7r!"
	$$endif
	totalcostformula "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"

	sformat "%0ln%-16r!$(min) to $(max)"
	editdlg 2
	opt
		begin add "$(label)" "?:1;$(costs)" noprint end
		end
}}


# Phobia macro

$$macro phobia(name, cost, varname, formula) {{
$$macrodesc("Phobia macro")
$$argdesc(name, "Name of phobia")
$$argdesc(cost, "Mild cost of phobia (severe cost is double)")
$$argdesc(varname, "Variable name for phobia (optional, used only if formula is specified)")
$$argdesc(formula, "Overrides cost (optional)")

	$$item($(name))
	$$ifdef(formula)
		$$ifdef(varname) varname "$(varname)" $$endif
		formula "$(formula)"
		level 1
		sformat "%0ln%-14r!$(cost)"
	$$else
		cost "$(cost)"
	$$endif
	cat Mental;Phobia
	format "%0ln (^o'Severity')%-14rc%-7r!"
	totalcostformula "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"

	editdlg 4
	opt
		begin mult "Severity" "?:1;Mild,1;Severe,2" noprint end
		end
}}


$$define supcostform "`No Cost`?0:tcfunc(c,a,@mo@,@p@)"

# Macro for constant super advantages.


$$macro csupadv(name, cost, adj, prereq, formula, format, cat, tcf) {{
$$macrodesc("Constant-cost super advantage")
$$argdesc(name, "Name of advantage")
$$argdesc(cost, "Cost of the advantage")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(formula, "Cost formula (optional, if present cost represents initial level)")
$$argdesc(format, "Display format (optional, default is ^n)")
$$argdesc(cat: cat, "Category (optional, default is Super Advantage)")
$$argdesc(tcf, "Total cost formula (optional)")

	$$item($(name))
	noviolation
	$$ifdef(formula)
		varname "v$$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")"
		level "$(cost)"
		formula "$(formula)"
	$$else
		#formula "x"
		#level "$(cost)"
		#checkexp "x=$(cost)"
		cost "$(cost)"
		keepcost
	$$endif
	sformat "%0ln%-10r!$(cost)"

	$$ifdef(cat)
		cat "$(cat)"
	$$else
		cat "Super Advantage"
	$$endif
	$$ifdef(format)
		format "%0l!$(format)%-14rx'displev(@c@)'%-7r! "
	$$else
		format "%0ln%-14rx'displev(@c@)'%-7r! "
	$$endif
	$$ifdef(tcf)
		totalcostformula "$(tcf)"
	$$else
		totalcostformula "$(supcostform)"
	$$endif
	$$ifdef (prereq) prereq "$(prereq)" $$endif
	$$ifdef (adj) adj $(adj) $$endif
	editdlg 4
}}


# Macro for level-based super advantages

$$macro lsupadv(name, cl, adj, checkexp, prereq, unit, formula, format, sformat, varname, cat) {{
$$macrodesc("Level-based super advantage")
$$argdesc(name, "Name of the advantage")
$$argdesc(cl, "Cost per level")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(checkexp, "Check expression (optional, default is x>0 and x>=&x")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(unit, "Name of unit (optional, default is \"level\"")
$$argdesc(formula, "Cost formula (optional, default is ~x*$(cl))")
$$argdesc(format, "Display format (optional)")
$$argdesc(sformat, "Selection format (optional)")
$$argdesc(varname, "Variable name (optional, default is alphanumeric characters of name")
$$argdesc(cat: cat, "Category (optional, default is Super Advantage)")

	$$item($(name))
	noviolation
	$$ifdef(cat)
		cat "$(cat)"
	$$else
		cat "Super Advantage"
	$$endif
	level 1
	$$ifdef (adj) adj $(adj) $$endif
	totalcostformula "$(supcostform)"
	$$ifdef (prereq) prereq "$(prereq)" $$endif

	$$ifdef(varname)
		varname "$(varname)"
	$$else
		varname "$$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")"
	$$endif
	$$ifdef (checkexp) checkexp $(checkexp)
	$$else checkexp "x>0 and x>=&x"
	$$endif

	$$ifdef(formula)
		formula "$(formula)"
	$$else
		formula ~x*$(cl)
	$$endif

	$$ifdef(format)
		format "%0l!$(format)%-14rc%-7rx'displev(@v@)'"
	$$else
		format "%0ln%-14rc%-7rx'displev(@v@)'"
	$$endif
	$$ifdef(sformat)
		sformat "%0l!$(sformat)"
	$$else
		$$ifdef(unit)
			sformat "%0ln%-16r!$(cl)/$(unit)"
		$$else
			sformat "%0ln%-14r!$(cl)/level"
		$$endif
	$$endif
}}


# Macro for fixed-level super advantages

$$macro flsupadv(name, min, max, label, costs, prereq, cat, adj, format, tcf)
{{
$$macrodesc("Fixed level-based super advantage")
$$argdesc(name, "Name of advantage")
$$argdesc(min, "Minimum cost")
$$argdesc(max, "Maximum cost")
$$argdesc(label, "Label for the option that contains the cost option")
$$argdesc(costs, "List of costs: e.g., Small,5;Medium,10;Large,15")
$$argdesc(prereq: req, "Prerequisities (optional)")
$$argdesc(adj: adj, "Adjustments (optiona)")
$$argdesc(cat: cat, "Category (optional, multiples separated by semicolons)")
$$argdesc(format, "Display format (optional)")
$$argdesc(tcf, "Total cost formula (optional)")

	$$item($(name))
	noviolation
	cost 0

	varname $$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")

	$$ifdef(tcf)
		totalcostformula "$(tcf)"
	$$else
		totalcostformula "$(supcostform)"
	$$endif

	$$ifdef(prereq)
		prereq "$(prereq)"
	$$endif

	$$ifdef(adj) adj "$(adj)" $$endif
	$$ifdef(cat)
		cat "$(cat)"
	$$else
		cat "Super Advantage"
	 $$endif

	$$ifdef(format)
		format "%0l!$(format)%-14rx'displev(@c@)'%-7r!"
	$$else
		format "%0ln (^o'$(label)')%-14rx'displev(@c@)'%-7r!"
	$$endif
	sformat "%0ln%-10r!$(min) to $(max)"
	editdlg 2
	$$ifdef(costs)
		opt
			begin add "$(label)" "?:1;$(costs)" noprint end
			end
	$$endif
}}



$$macro q(quirk) {{
$$macrodesc("Quirk macro")
$$argdesc(quirk, "Text of the quirk")

	$$item($(quirk))
	cost -1
	keepcost
	format %0ln%-2rc
	sformat %0ln
	editdlg 4
}}




$$macro powcostform() {{
$$hideMacro()
	totalcostformula "tcpow(c,a,aux,@mo@,@p@)"
}}

# Super power macro.

$$macro suppow(name, type, lc, attr, prereq, costFormula, format)
{{
$$macrodesc("Super power macro (follow with supdmg macro to indicate damage)")
$$argdesc(name, "Name of power")
$$argdesc(type: suppowtype, "Type of power (RM, RP, AM, etc.)")
$$argdesc(lc, "Level cost")
$$argdesc(attr: attribute, "Base attribute (IQ, DX, etc.)")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(costFormula, "Level cost formula (optional, default is Power Level * $(lc))")
$$argdesc(format, "Format (optional, use ^n (^o'Damage') for powers with damage)")

	$$item($(name))
	noviolation
	cat "Super Power"
	level $(attr)
	$$ifdef (prereq) prereq "$(prereq)" $$endif
	class "$(type)$(lc)"
	formula "optPresent('Use Skill')?0:ss(~x,$(attr))"
	checkexp "optPresent('Use Skill')?x=listItemInfo('Skills',optValue('Use Skill'),'@v@'):x>$(attr)-5"
	format "$$ifdef(format)%0l!$(format)$$else%0ln$$endif%-20ll%-14rc%-7rv(^o'Power')"
	sformat "%0ln%-$$exp("strlen(lc)+6")rl"
	varname $$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")
	totalcostformula "tcpow(c,a,aux,@mo@,@p@)"
	opt
		begin auxcost Power $$ifdef(costFormula) "$(costFormula)" $$else "supCost(x,$(lc))" $$endif 1
			noprint
			end
		end
}}

$$macro supdmg(type, dmgformula) {{
$$macrodesc("Super power damage: adds a Damage option to a power")
$$argdesc(type, "Type of damage (optional, expression required, default is 'cr')")
$$argdesc(dmgformula, "formula to display damage (optional)")

	opt	begin exp Damage "format('%s %s', optPresent('Impaling')?'imp':(optPresent('Cutting')?'cut':$$ifdef(type)$(type)$$else'cr'$$endif), \
$$ifdef(dmgformula)$(dmgformula)$$else format('%dd',`Power`)$$endif)" noprint end
		end
}}



# Skill macro

$$macro skill(name, class, cat, def, prereq, tl, formula, checkexp, adj, varname, fmt, sformat) {{
$$macrodesc("Skill macro")
$$argdesc(name, "Name of skill")
$$argdesc(class: skilldiff, "Skill class (ME, MA, etc.). Indicate PH/HT to base PH skill on HT, MA! to indicate mental skill unaffected by Eidetic Memory")
$$argdesc(cat: cat, "Skill category. Also used for categories of skills that receive bonuses")
$$argdesc(def, "Default values (optional). E.g.: animalhandling-3;dx-5")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(tl, "TL of skill (optional). If same as campaign, enter \"tl\", otherwise enter number")
$$argdesc(formula, "Formula (optional, default is standard for class)")
$$argdesc(checkexp, "Check expression (optional)")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(varname, "Variable name (optional, default is name with non-alphanumerics removed)")
$$argdesc(fmt, "Display format (optional, default is ^n)")
$$argdesc(sformat, "Selection format (optional)")

	$$item($(name))
	noviolation
	$$ifdef(varname)
		varname "$(varname)"
	$$else
		varname $$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")
	$$endif
	$$ifdef (cat) cat "$(cat)" $$endif
	$$ifdef(prereq) prereq "$(prereq)" $$endif
	$$scan(class, "(ME|MA|MH|MVH|PE|PA|PH)(!?)/(IQ|ST|DX|HT|iq|st|dx|ht)|(ME|MA|MH|MVH|PE|PA|PH)(!?)",
		skfunc, noEidetic, char)
	$$ifnull(skfunc) $$error(Unrecognized skill difficulty in skill macro invocation) $$endif
	class "$(skfunc)"

	totalcostformula "(c+a)*m"

	$$ifdef(adj)
		adj "$(adj)"
	$$endif

	$$ifdef(formula)
		formula "$$ifdef(tl)($(formula))+0*tl$$else$(formula)$$endif"
	$$else
		$$ifdef(char)
			$$if(strindex(class, "!"))
				$$define skform $(skfunc)(~x,$(char))
			$$else
				$$if(strindex(skfunc, "/^[Mm]/"))
					# Mental skill that can use eidetic memory bonus.
					$$define skform M$(skfunc)(~x,$(char))
				$$else
					$$define skform $(skfunc)(~x,$(char))
				$$endif
			$$endif
		$$else
			$$if(strindex(skfunc, "/^[Mm]/"))
				$$if(strindex(class, "!"))
					$$define skform $(skfunc)(~x,iq)
				$$else
					$$define skform M$(skfunc)(~x,iq)
				$$endif
			$$else
				$$define skform $(skfunc)(~x,dx)
			$$endif
		$$endif
		formula "$(skform)$$ifdef(tl)+(0*tl)$$endif"
	$$endif

	$$ifdef(def)
		defbaseable
		$$scan(def, "^(.*)\#(.*)$|^(.*)$", s_def, s_vars)
		default "bv(v,x);$(s_def)$$if(s_def!='`Default`');`Default`$$endif"
		$$ifdef(formula)
			$$ifdef(s_vars)
				defFormula "($$exp("replaceString(replaceString(formula, '\"',''), '~', '')"))+0*$(s_vars)"
			$$else
				defFormula "$$exp("replaceString(replaceString(formula, '\"',''), '~', '')")"
			$$endif
		$$else
			$$ifdef(char)
				$$if(strindex(class, "!"))
					$$define skform $(skfunc)(x,$(char))
				$$else
					$$if(strindex(skfunc, "/^m/"))
						# Mental skill that can use eidetic memory bonus.
						$$define skform M$(skfunc)(x,$(char))
					$$else
						$$define skform $(skfunc)(x,$(char))
					$$endif
				$$endif
			$$else
				$$if(strindex(skfunc, "/^[Mm]/"))
					$$if(strindex(class, "!"))
						$$define skform $(skfunc)(x,iq)
					$$else
						$$define skform M$(skfunc)(x,iq)
					$$endif
				$$else
					$$define skform $(skfunc)(x,dx)
				$$endif
			$$endif
			defFormula "$(skform)$$ifdef(s_vars)+0*$(s_vars)$$endif"
		$$endif
	$$endif

	$$ifnull(char)
		$$if(strindex(skfunc, "/[Pp]/"))
			$$define char DX
		$$else
			$$define char IQ
		$$endif
	$$endif

	$$if(strindex(skfunc, "e"))
		level "$(char)-1"
	$$else
		$$if(strindex(skfunc, "a"))
			level "$(char)-2"
		$$else
			$$if(strindex(skfunc, "vh"))
				level "$(char)-4"
			$$else
				level "$(char)-3"
			$$endif
		$$endif
	$$endif

	$$ifdef(checkexp)
		checkexp "$(checkexp)"
	$$else
		checkexp "skchk(x,c)"
	$$endif
	$$define tloption TL
	$$ifdef(tl)
		$$scan(tl, "^(.*)/(.*)$|^(.*)$", techlev, tlrange)
		$$if(strindex(tl, "/^ *[0-9]+\+[0-9]+ *$/") > 0)
			$$define tloption Display TL
		$$endif
	$$else
		$$define	techlev
	$$endif
	$$ifdef(fmt)
		$$if(strindex(fmt, '%0') > 0)
			format "$(fmt)"
		$$else
			format "%0l!$(fmt)$$ifdef(techlev)/TL^o'$(tloption)'$$endif^x|doptlist('Specialty')|%-18ll%-12rc%-7rx|dsk(@v@)|"
		$$endif
	$$else
		format "%0ln$$ifdef(techlev)/TL^o'$(tloption)'$$endif^x|doptlist('Specialty')|%-18ll%-12rc%-7rx|dsk(@v@)|"
	$$endif
	$$ifdef(sformat)
		sformat "$(sformat)"
	$$else
		sformat %0ln$$ifdef(techlev)/TL$$endif%-5ll
	$$endif
	$$ifdef(tl)
		opt
		$$if(techlev = "tl")
			begin exp TL tl+&tl noprint keepold end
		$$else
			$$if(strindex(techlev, "/^ *[0-9]+\+[0-9]+ *$/") > 0)
				begin exp TL "`Display TL`" noprint keepold end
				begin text "Display TL" "$(techlev)" noprint keepold end
			$$else
				begin exp TL "$(techlev)" noprint keepold end
			$$endif
		$$endif
		$$ifdef(tlrange)
			begin text "TL Range" "$(tlrange)" noprint keepold end
		$$endif
		end
	$$endif
}}



$$macro lang(name, diff, def, cat)
{{
$$macrodesc("Language macro")
$$argdesc(name, "Language name")
$$argdesc(diff, "Difficulty (Optional, default is MA, otherwise MA, ME, MH, MVH)")
$$argdesc(def, "Default (optional)")
$$argdesc(cat: cat, "Additional categories")

	$$ifdef(cat)
		$$define lcat	Language;$(cat)
	$$else
		$$define lcat Language
	$$endif
	$$if(diff = "MA" or diff = "")
		$$skill($(name), MA, $(lcat), $(def), , , "malang(~x)", "langchk(x,&x,c)", , , "^n^x|`Native`?' (native)':''|")
	$$else
		$$if(diff = "MH")
			$$skill($(name), MH, $(lcat), $(def), , , "mhlang(~x)", "langchk(x,&x,c)", , , "^n^x|`Native`?' (native)':''|")
		$$else
			$$if(diff = "ME")
				$$skill($(name), ME, $(lcat), $(def), , , "melang(~x)", "langchk(x,&x,c)", , , "^n^x|`Native`?' (native)':''|")
			$$else
				$$if(diff = "MVH")
					$$skill($(name), MVH, $(lcat), $(def), , , "mvhlang(~x)", "langchk(x,&x,c)", , , "^n^x|`Native`?' (native)':''|")
				$$else
					$$skill($(name), MA, $(lcat), $(def), , , "malang(~x)", "langchk(x,&x,c)", , , "^n^x|`Native`?' (native)':''|")
				$$endif
			$$endif
		$$endif
	$$endif
	opt	begin text "Native" "?+0;" dispexp "'l'" noprint end
		end
}}

$$macro flang(name, diff)
{{
	$$lang($(name), $(diff), , Fantasy)
}}

$$macro wlang(name, diff)
{{
	$$lang($(name), $(diff), , World)
}}

$$macro alang(name, diff)
{{
	$$lang($(name), $(diff), , Archaic)
}}


# Science skills have the specialty option preadded.

$$macro sciskill(name, class, cat, def, prereq, tl, formula, checkexp, adj, varname, format) {{
$$macrodesc("Science skill (has Specialty option)")
$$argdesc(name, "Name of skill")
$$argdesc(class, "Skill class (ME, MA, etc.). Indicate PH/HT to base PH skill on HT")
$$argdesc(cat: cat, "Skill category. Also used for categories of skills that receive bonuses")
$$argdesc(def, "Default values (optional). E.g.: animalhandling-3;dx-5")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(tl, "TL of skill (optional). If same as campaign, enter \"tl\", otherwise enter number")
$$argdesc(formula, "Formula (optional, default is standard for class")
$$argdesc(checkexp, "Check expression (optional)")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(varname, "Variable name (optional, default is name with non-alphanumerics removed)")
$$argdesc(format, "Display format (optional, default is ^n)")

	$$skill($(name), $(class), $(cat), $(def), $(prereq), $(tl), $(formula), $(checkexp), $(adj), $(varname), $(format))
	opt
		begin text Specialty "" noprint end
		end
}}


# Engineering skills have a special formula that depends on TL and mathematical ability.

$$macro engskill(name, class, cat, def, prereq, tl, formula, checkexp, adj, varname, format) {{
$$macrodesc("Engineering skill")
$$argdesc(name, "Name of skill")
$$argdesc(class, "Skill class (ME, MA, etc.).")
$$argdesc(cat: cat, "Skill category. Also used for categories of skills that receive bonuses")
$$argdesc(def, "Default values (optional). E.g.: geology-6")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(tl, "TL of skill (required). If same as campaign, enter \"tl\", otherwise enter number")
$$argdesc(formula, "Formula (optional, default is standard for class")
$$argdesc(checkexp, "Check expression (optional)")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(varname, "Variable name (optional, default is name with non-alphanumerics removed)")
$$argdesc(format, "Display format (optional, default is ^n)")

	$$define tloption TL
	$$ifdef(tl)
		$$scan(tl, "^(.*)/(.*)$|^(.*)$", techlev, tlrange)
		$$if(strindex(tl, "/^ *[0-9]+\+[0-9]+ *$/") > 0)
			$$define tloption Display TL
		$$endif
	$$endif
	$$sciskill($(name), $(class), $(cat), $(def), $(prereq), $(tl), "mmh(~x-(MathematicalAbility and TL+&tl>=6?2:0),iq)", $(checkexp), $(adj), $(varname),
		"%0ln/TL^o'$(tloption)'^x|doptlist('Specialty')|%-18ll%-12rc%-7rx|format('%d%s',@v@,@bonus@ or MathematicalAbility and TL+&tl>=6?'*':'')|")
}}



# Melee combat skill that can have parry.

$$macro mcskill(name, class, cat, def, prereq, tl, formula, checkexp, adj, varname, format, parry) {{
$$macrodesc("Melee combat skill (has Parry option)")
$$argdesc(name, "Melee combat skill")
$$argdesc(class, "Skill class (ME, MA, etc.). Indicate PH/HT to base PH skill on HT")
$$argdesc(cat: cat, "Skill category. Also used for categories of skills that receive bonuses")
$$argdesc(def, "Default values (optional). E.g.: animalhandling-3;dx-5")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(tl, "TL of skill (optional). If same as campaign, enter \"tl\", otherwise enter number")
$$argdesc(formula, "Formula (optional, default is standard for class")
$$argdesc(checkexp, "Check expression (optional)")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(varname, "Variable name (optional, default is name with non-alphanumerics removed)")
$$argdesc(format, "Display format (optional, default is ^n)")
$$argdesc(parry, "The parry multiplier (1/2, 2/3, 1/2-1, etc.)")

	$$ifdef(adj)
		$$error(Adjustment not null for melee combat)
	$$endif
	$$skill($(name), $(class), $(cat), $(def), $(prereq), $(tl), $(formula), $(checkexp), "zparry+1", $(varname), $(format))
	opt
		exp Parry "integer(x*$$ifnull(parry).5+wpbonus(0)$$else$(parry)$$endif)"
		end
}}

# Blocking combat skill that can have a block.

$$macro bcskill(name, class, cat, def, prereq, tl, formula, checkexp, adj, varname, format) {{
$$macrodesc("Blocking combat skill (has Block option)")
$$argdesc(name, "Combat skill with block")
$$argdesc(class, "Skill class (ME, MA, etc.). Indicate PH/HT to base PH skill on HT")
$$argdesc(cat: cat, "Skill category. Also used for categories of skills that receive bonuses")
$$argdesc(def, "Default values (optional). E.g.: animalhandling-3;dx-5")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(tl, "TL of skill (optional). If same as campaign, enter \"tl\", otherwise enter number")
$$argdesc(formula, "Formula (optional, default is standard for class")
$$argdesc(checkexp, "Check expression (optional)")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(varname, "Variable name (optional, default is name with non-alphanumerics removed)")
$$argdesc(format, "Display format (optional, default is ^n)")

	$$ifdef(adj)
		$$error(Adjustment not null for melee combat)
	$$endif
	$$skill($(name), $(class), $(cat), $(def), $(prereq), $(tl), $(formula), $(checkexp), "zblock+1", $(varname), $(format))
	opt
		exp Block "integer(x/2)"
		end
}}


$$macro sp(name, class, resist, cat, time, dur, energy, prereq, page, formula, addcat)
{{
$$macrodesc("Spell macro")
$$argdesc(name, "Spell name (/TL for TL, * for VH)")
$$argdesc(class: spellclass, "Spell class (optional, default is Regular. Other values may be Information, Special, etc.)")
$$argdesc(resist, "Resisted by (optional, values might be IQ, DX, etc.)")
$$argdesc(cat: spellcat, "Spell college (Air, Earth, Animal, etc.)")
$$argdesc(time, "Casting time (optional, default is 1 sec.)")
$$argdesc(dur, "Duration (optional, default is 1 min.)")
$$argdesc(energy, "Energy required (optional)")
$$argdesc(prereq: req, "Prerequisites (optional)")
$$argdesc(page, "Page number (M24;B155, etc.)")
$$argdesc(formula, "Standard formula override (optional)")
$$argdesc(addcat: cat, "Additional spell categories")

	$$if(strindex(name, "/TL"))
		$$scan(name, "^(.+)/TL(\\*)$|^(.+)/TL$", n, vh)
		$$define TL tl
	$$else
		$$define TL
		$$scan(name, "^(.+)(\\*)$|^(.+)$", n, vh)
	$$endif

	$$ifnull(n)
		$$error(Spell name must be specified)
	$$endif

	$$item($(n))
	noviolation
	cat "$(cat)$$ifdef(addcat);$(addcat)$$endif"
	varname "$$exp("replaceString(n, \"/[^a-zA-Z]/\", '')")"
	$$ifdef(vh)
		class "VH"
	$$endif
	$$ifdef(formula)
		level "iq+magery-3"
		formula "$(formula)"
	$$else
		$$ifdef(vh)
			level "iq+magery-3"
			formula vhsp(~x,iq)
		$$else
			level "iq+magery-2"
			formula hsp(~x,iq)
		$$endif
	$$endif
	checkexp "spchk(x,c)"
	format "%0ln$$ifdef(tl)/TL^o'TL'$$endif$$ifdef(vh)*$$endif%-32lt%-12rc%-7rx'displev(@v@)'"
	sformat "%0ln$$ifdef(tl)/TL$$endif$$ifdef(vh)*$$endif$$if(strindex(cat,';')>0) [$$exp("replaceString(replaceString(replaceString(cat,'/[\"*]/',''), '/^[^;]+;/',''),';',', ')")]$$endif%-5nl"
	$$ifdef(prereq) prereq "$(prereq)" $$endif
	opt
		text Class $$ifdef(class) "$(class)" $$else Regular $$endif
		$$ifdef(page) text Page "$(page)" $$endif
		$$ifdef(resist) text Resist "$(resist)" $$endif
		text "Time to cast" $$ifdef(time) "$(time)" $$else "1 sec." $$endif
		text Duration $$ifdef(dur) "$(dur)" $$else "1 min." $$endif
		$$ifdef(energy) text Energy "$(energy)" $$endif
		$$ifdef(tl) begin exp TL tl+&tl noprint end $$endif
		end
}}



# Equipment macro.

# Standard format for possessions.

$$define possformat "%0ln^x|dquan(`Quantity`,1)|%-18rx|dp(0)|%-7rx|dew(@c@)|"
$$define posswtfmt	"%-7rx|dew(@c@)|"

# Basic equipment macro.
# name: name of item
# weight: weight
# price: $ cost
# cat: equipment category (optional)
# notes: any extra notes.

$$macro equip(name, weight, price, cat, notes, tl, format, sformat, page)
{{
$$macrodesc("Equipment macro")
$$argdesc(name, "Name of equipment")
$$argdesc(weight, "Weight (optional, in lbs). If omitted, weight is 0")
$$argdesc(price, "Price (in $). To indicate multiple prices, use the form \"Early 1900's,35;Modern,300\"")
$$argdesc(cat: cat, "Equipment category (optional)")
$$argdesc(notes, "Any extra notes (optional). For example, number of hands required, etc.")
$$argdesc(page, "Page number reference (optional)")

	$$item($(name))
	noviolation
	keepcost
	$$ifdef(cat) cat "$(cat)" $$endif
	$$ifdef(weight)
		$$if(weight>1000)
			editdlg 2
			opt
				begin text Weight "$(weight)" noprint end
				end
			cost 0
			$$ifdef(format)
				format "%0l!$(format)%-18rx|dp(0)|%-7rx|dew(`Weight`)|"
			$$else
				format "%0ln^x|dquan(`Quantity`,1)|%-18rx|dp(0)|%-7rx|dew(`Weight`)|"
			$$endif
			$$ifdef(sformat)
				sformat "%0l!$(sformat)$$pricefmt($(price))%-7rx|dew(`Weight`)|"
			$$else
				sformat "%0ln$$pricefmt($(price))%-7rx|dew(`Weight`)|"
			$$endif
		$$else
			editdlg 4
			cost "$(weight)"
			$$ifdef(format)
				format "%0l!$(format)%-18rx|dp(0)|%-7rx|dew(@c@)|"
			$$else
				format $(possformat)
			$$endif
			$$ifdef(sformat)
				sformat "%0l!$(sformat)$$pricefmt($(price))$(posswtfmt)"
			$$else
				sformat "%0ln$$pricefmt($(price))$(posswtfmt)"
			$$endif
		$$endif
	$$else
		editdlg 2
		cost 0
		$$ifdef(format)
			format "%0l!$(format)%-18rx|dp(0)|%-7r!--"
		$$else
			format "%0ln^x|dquan(`Quantity`,1)|%-18rx|dp(0)|%-7r!--"
		$$endif
		$$ifdef(sformat)
			sformat "%0l!$(sformat)$$pricefmt($(price))%-7r!--"
		$$else
			sformat "%0ln$$pricefmt($(price))%-7r!--"
		$$endif
	$$endif
	$$ifdef(notes) notes "$(notes)" $$endif
	adj "posscost+max(1,`Quantity`)*`Base Price`*(`No Cost`=0)"
	totalcostformula "$(equiptcf)"
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		$$ifdef(tl) begin text TL "??$(tl)" noprint end $$endif
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}


$$macro rope(name, weight, price, unit, notes, supports, tl)
{{
	$$item($(name))
	noviolation
	keepcost
	cat "Rope"
	editdlg 4
	$$ifdef(weight)
		cost $(weight)
	$$else
		cost 0
	$$endif
	format "%0ln (^o'Length')%-18rx|dp(0)|$(posswtfmt)"
	sformat "%0ln$$pricefmt($(price))/10yds$(posswtfmt)"
	$$ifdef(notes) notes "$(notes)" $$endif
	adj "posscost+max(1,`Quantity`)*`Base Price`$$if(tl>=6)*(`High Quality`?5:1)$$endif*(`No Cost`=0)"
	$$ifdef(tl) prereq "Configuration:TL>=$(tl)-&tl" $$endif
	totalcostformula "$(equiptcf)"
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`High Quality`?5:1)*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		begin exp Length "format('%d yards', max(`Quantity`,1)*$(unit))" noprint end
		begin mult Quantity "??1;1;x;x>0" noprint end
		$$if(tl>=6) begin text "High Quality" "?+0;" dispexp 'l' end $$endif
		$$ifdef(supports) exp Supports "format('%d lbs', $(supports)$$if(tl>=6)*(`High Quality`?2:1)$$endif)" $$endif
		$$ifdef(tl) begin text TL "??$(tl)" noprint end $$endif
		end
}}



$$macro vehicle(name, weight, price, cat, notes, tl)
{{
$$macrodesc("Vehicle macro (weight not counted as encumbrance)")
$$argdesc(name, "Name of vehicle (never ")
$$argdesc(weight, "Weight of vehicle")
$$argdesc(price, "Price of vehicle (in $)")
$$argdesc(cat: cat, "Category (optional)")
$$argdesc(notes, "Any notes about the vehicle")
$$argdesc(tl, "Tech level of vehicle")

	$$item($(name))
	noviolation
	keepcost
	$$ifdef(cat) cat "$(cat)" $$endif
	editdlg 2
	cost 0
	format "%0ln^x|`Quantity`>1?' (`Quantity`)':''|%-18rx|dp(0)|%-7r$$ifdef(weight)x|dew(`Weight`)|$$else!$$endif"
	sformat "%0ln$$pricefmt($(price))%-7r$$ifdef(weight)x|dew(`Weight`)|$$else!$$endif"
	$$ifdef(notes) notes "$(notes)" $$endif
	adj "posscost+max(1,`Quantity`)*`Base Price`*(`No Cost`=0)"
	totalcostformula "$(equiptcf)"
	opt
		$$ifdef(weight)
			begin text Weight "$(weight)" noprint end
		$$endif
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		$$ifdef(tl) begin text TL "??$(tl)" noprint end $$endif
		end
}}



$$macro money(name, weight, price)
{{
$$macrodesc("Money macro")
$$argdesc(name, "Name of the coin")
$$argdesc(weight, "Weight per coin (for example, 0.01)")
$$argdesc(price, "Price of each coin (in $)")

	$$item($(name))
	noviolation
	cat "Money"
	level 1
	checkexp x>0
	cost $(weight)
	formula $(weight)*x
	format "%0lv ^n%-16rx|dp(0)|$(posswtfmt)"
	sformat "%0ln$$pricefmt($(price))$(posswtfmt)"
	adj "posscost+x*`Base Price`"
	totalcostformula c
	generic
	opt
		begin exp Price "x*`Base Price`" noprint end
		$$priceopt($(price))
		end
}}


# Body part macro for armor.

$$macro bp(part, drimp, pdimp)
{{$$hideMacro()b_$(part)DR+`Armor Worn`*(`DR`+`Extra DR`);b_$(part)PD+`Armor Worn`*(`PD`+`Extra PD`)$$ifdef(drimp);b_$(part)DRimp+`Armor Worn`*(`DR vs imp`?`DR vs imp`+`Extra DR`:0)$$endif$$ifdef(pdimp);b_$(part)PDimp+`Armor Worn`*(`PD vs imp`?`PD vs imp`+`Extra PD`:0)$$endif}}

#
# bodyparts: The list of body parts for the armor. It must be one or more of
# the following values, separated by commas (no spaces): Head, Arms, Legs,
# Body, Hands, Feet, Whole. Unless the "Whole" body part is specified, the
# general PD value will not be set by the armor. This must be double-quoted if it
# appears in a comma-delimited macro invocation.

$$macro armor(name, tl, pd, dr, price, weight, bodyparts, note, page)
{{
$$macrodesc("Armor macro (may be used for pieces of armor such as helmets)")
$$argdesc(name, "Name of armor")
$$argdesc(tl, "TL of armor")
$$argdesc(pd, "PD of armor (indicate 3/1 for normal/piercing damage)")
$$argdesc(dr, "DR of armor (indicate 4/2 for normal/piercing damage)")
$$argdesc(price, "Price of armor (in $)")
$$argdesc(weight, "Weight of armor (in lbs)")
$$argdesc(bodyparts: bodyparts, "Names of parts of body covered (one or more of Head, Arms, Legs, Body, Hands, Feet, Whole, separated by commas)")
$$argdesc(note, "Extra notes (optional)")
$$argdesc(page, "Page number reference (optional)")

	$$item($(name))
	noviolation
	keepcost
	cat Armor
	editdlg 4
	$$ifdef(weight) cost $(weight) $$else cost 0 $$endif
	$$scan(pd, "([0-9]+)/([0-9]+)|(.*)", t_bpd, t_ipd)
	$$scan(dr, "([0-9]+)/([0-9]+)|(.*)", t_bdr, t_idr)
	format "%0ln (^x|dpddr(0)|^x|dquan(`Quantity`,0)|)%-18rx|dp(0)|$(posswtfmt)"
	sformat "%0ln (PD $(pd), DR $(dr))$$pricefmt($(price))$(posswtfmt)"
	adj "posscost+max(1,`Quantity`)*`Base Price`*(`No Cost`=0);$$repeat($(bodyparts), b, " *, *", ";")$$bp($(b),$(t_idr),$(t_ipd))$$endrepeat"
	totalcostformula "$(equiptcf)"
	$$ifdef(tl) prereq "Configuration:TL>=$(tl)-&tl" $$endif
	$$ifdef(note) notes "$(note)" $$endif
	$$scan(bodyparts, "^([^,]+)", firstbp)
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		begin text "Armor Worn" "?@format('?+%d;',b_$(firstbp)DR=0)" noprint dispexp 'l' end
		$$ifdef(t_bpd) begin text PD "??$(t_bpd);$(t_bpd);x" noprint end $$endif
		$$ifdef(t_ipd) begin text "PD vs imp" "??$(t_ipd);$(t_ipd);x" noprint end $$endif
		$$ifdef(t_bdr) begin text DR "??$(t_bdr);$(t_bdr);x" noprint end $$endif
		$$ifdef(t_idr) begin text "DR vs imp" "??$(t_idr);$(t_idr);x" noprint end $$endif
		$$ifdef(tl) begin text TL "??$(tl)" noprint end $$endif
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}

# Clothing macro

$$macro clothing(name, weight, price, pd, dr, note, tl, page)
{{
$$macrodesc("Clothing macro")
$$argdesc(name, "Name of clothing")
$$argdesc(weight, "Weight (in lbs)")
$$argdesc(price, "Price (in $)")
$$argdesc(pd, "PD of clothing")
$$argdesc(dr, "DR of clothing")
$$argdesc(note, "Any extra notes")
$$argdesc(tl, "TL")

	$$item($(name))
	noviolation
	cat Clothing
	editdlg 4
	$$ifdef(weight) cost "$(weight)" $$endif
	format $(possformat)
	sformat "%0ln$$pricefmt($(price))%-7r$$ifdef(weight)x|dew(@c@)|$$else!$$endif"
	adj "posscost+max(1,`Quantity`)*`Base Price`*(`No Cost`=0)"
	totalcostformula "$(equiptcf)"
	$$ifdef(note) notes "$(note)" $$endif
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		$$ifdef(pd) adj PD "apd+x+`Extra PD`" $(pd) $$endif
		$$ifdef(dr) adj DR "adr+x+`Extra DR`" $(dr) $$endif
		$$ifdef(tl) text TL "??$(tl)" $$endif
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}


$$macro handweapon(name, skill, dmg, reach, price, weight, st, notes, parry, extracat, adj, format, sformat, page)
{{
$$macrodesc("Hand weapon (use sword macro for swords)")
$$argdesc(name, "Name of hand weapon")
$$argdesc(skill, "List of skill variable names that can be used, separated by commas")
$$argdesc(dmg, "Damage type: cut sw, imp sw+1, cr sw+3, etc. Separate multiple types with semicolons")
$$argdesc(reach, "Reach of weapon. Delimit reaches corresponding to damage by semicolons")
$$argdesc(price, "Price of weapon (in $)")
$$argdesc(weight, "Weight of weapon in lbs")
$$argdesc(st, "Minimum ST required (optional)")
$$argdesc(notes, "Any descriptive notes (number of hands, etc.)")
$$argdesc(parry, "Parry multiple (optional, default is 1/2. Fencing would be 2/3, knife 1/2-1)")
$$argdesc(extracat, "Additional categories (beyond Hand Weapon)")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(sformat, "Selection format")

	$$item($(name))
	keepcost
	noviolation
	cat "Hand Weapon$$ifdef(extracat);$(extracat)$$endif"
	$$weapclass($(skill))

	varname "w_$$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")"
	$$ifdef(format)
		format "%0l!$(format)%-18rx|dp(0)|$(posswtfmt)"
	$$else
		format "%0ln$$ifdef(dmg) (^o'Damage'$$ifdef(skill), Skill: ^o'Skill', Parry: ^o'Parry'$$endif^x|dquan(`Quantity`,0)|)$$endif%-18rx|dp(0)|$(posswtfmt)"
	$$endif
	$$ifdef(sformat)
		sformat "%0l!$(sformat)$$pricefmt($(price))$$ifdef(weight)%-7rx|dew($(weight))|$$else%-7r!--$$endif"
	$$else
		sformat "%0ln$$showdmg($(dmg))$$pricefmt($(price))$$ifdef(weight)%-7rx|dew($(weight))|$$else%-7r!--$$endif"
	$$endif
	$$ifdef(st) prereq "Main:ST>=$(st)" $$endif

	$$scan(weight, "^([0-9]+)/(.*)$", w, unit)
	$$ifdef(w)
		formula "x*$(w)+0*ST$$ifdef(skill)*max($(skill))$$endif"
		level 1
		editdlg 0
	$$else
		level "$$ifnull(weight)0$$else$(weight)$$endif"
		formula "x+0*ST$$ifdef(skill)*max($(skill))$$endif"
		editdlg 4
	$$endif

	adj "posscost+`Price`$$ifdef(adj);$(adj)$$else;zparry+1$$endif"
	totalcostformula "$(equiptcf)"
	notes "$(notes)"

	opt
		$$scan(price, "^([0-9]+)/(.*)$", cost, unit)
		$$ifdef(cost)
			begin exp Price "x*max(1,`Quantity`)*`Base Price`*qindex(`Weapon Quality`,1,.4,4,20.)" noprint end
			begin text "Base Price" "??$(cost);$(cost);;x>=0" noprint
				dispexp "'l: o/$(unit)'"
				end
		$$else
			begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)*qindex(`Weapon Quality`,1,.4,4,20.)" noprint end
			$$priceopt($(price))
		$$endif
		$$ifdef(dmg) $$dmg($(dmg), "0,0,1,1", $(skill)) $$endif
		$$ifdef(reach) text Reach "$(reach)" $$endif
		$$ifdef(st) text ST "??$(st)" $$endif
		$$dispSkill($(skill), $(parry))
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}


$$macro shield(name, skill, pd, price, weight, hits, dmg, tl, page)
{{
$$macrodesc("Shield macro")
$$argdesc(name, "Name of shield")
$$argdesc(skill, "List of skill variable names separated by commas (e.g., shield,dx-4,buckler-2)")
$$argdesc(pd, "PD of shield")
$$argdesc(price, "Price of shield (in $)")
$$argdesc(weight, "Weight of shield (in lbs)")
$$argdesc(hits, "Shield hit points")
$$argdesc(dmg, "Damage shield does: usually cr thr")
$$argdesc(tl, "TL of shield")

	$$if(hits <> '' and dmg <> '')
		$$handweapon($(name), , $(dmg), 1, $(price), $(weight), , , , Shield, zblock+1, 
			"^n (PD ^o'PD', Hits ^o'Hits', ^o'Damage', Skill: ^o'Skill', Block: ^o'Block'^x|dquan(`Quantity`,0)|)",
			"^n (PD $(pd), Hits $(hits))")
	$$else
		$$handweapon($(name), , , 1, $(price), $(weight), , , , Shield, zblock+1,
			"^n (PD ^o'PD', Skill: ^o'Skill', Block: ^o'Block'^x|dquan(`Quantity`,0)|)",
			"^n (PD $(pd))")
	$$endif
	noviolation
	keepcost
	$$ifdef(tl)
		prereq "Configuration:TL>=$(tl)-&tl"
	$$endif
	opt
		begin text "Shield Used" "?@format('?+%d;',spd=0)" noprint dispexp 'l' end
		begin adj PD "spd+`Shield Used`*(x+`Extra PD`)" "$(pd)" noprint end
		$$ifdef(hits)
			begin text Hits "$(hits)" keepold noprint end
		$$endif
		$$ifdef(skill)
			begin exp Skill "max($(skill))" noprint end
			begin exp Block "integer((`Skill`)/2)" noprint end
		$$endif
		$$ifdef(tl) exp TL "$(tl)" $$endif
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}


$$macro showmissdmg(name, dmg)
{{$$ifdef(dmg), $(name) $$exp("replaceString(replaceString(dmg, '`', ''), 'integer', '')")$$endif}}


$$macro missile(name, skill, damage, ss, acc, halfd, max, price, weight, st, notes, format, sformat, page)
{{
$$macrodesc("Missile weapon macro")
$$argdesc(name, "Name of missile")
$$argdesc(skill, "List of skill variable names, separated by commas")
$$argdesc(damage, "Damage (4d+1, etc.)")
$$argdesc(ss, "Snap shot")
$$argdesc(acc, "Accuracy")
$$argdesc(halfd, "Half damage distance")
$$argdesc(max, "Maximum distance")
$$argdesc(price, "Price (in $)")
$$argdesc(weight, "Weight (in lbs)")
$$argdesc(st, "Minimum ST required")
$$argdesc(notes, "Additional notes")

	$$item($(name))
	noviolation
	keepcost
	cat "Missile Weapon;Ranged Weapon"
	$$ifdef(notes)
		notes "$(notes)"
	$$endif
	$$weapclass($(skill))

	$$ifdef(format)
		format "%0l!$(format)%-18rx|dp(0)|$(posswtfmt)"
	$$else
		format "%0ln ($$ifdef(damage)^o'Damage'$$endif$$if(skill<>'' and damage<>''), $$endif$$ifdef(skill)Skill: ^o'Skill'$$endif^x|dquan(`Quantity`,0)|)%-18rx|dp(0)|$(posswtfmt)"
	$$endif
	$$ifdef(sformat)
		sformat "%0l!$(sformat)$$pricefmt($(price))%-7rx|dew($(weight))|"
	$$else
		sformat "%0ln ($(damage)$$ifdef(acc), Acc ^o'Acc'$$endif$$showMissDmg(D, $(halfd))$$showMissDmg(MAX, $(max)))$$pricefmt($(price))%-7rx|dew($(weight))|"
	$$endif

	$$ifdef(st) prereq "Main:ST>=$(st)" $$endif

	varname "w_$$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")"
	level "$(weight)"
	formula "x+0*ST$$ifdef(skill)*max($(skill))$$endif"
	editdlg 4

	adj "posscost+`Price`"
	totalcostformula "$(equiptcf)"
	
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)*(`Weapon Quality`>2?4:1)" noprint end
		$$priceopt($(price))
		$$ifdef(st)
			begin text "ST" "??$(ST);$(ST);x;x>=7" noprint end
		$$endif
		$$ifdef(damage) $$dmg($(damage), , $(skill)) $$endif
		$$ifdef(skill) begin exp Skill "max($(skill))+`Extra Accuracy`" noprint end $$endif
		$$ifdef(acc) text Acc ??$(acc) $$endif
		$$ifdef(ss) text SS ??$(ss) $$endif
		$$ifdef(halfd) exp "Half DMG" "round(($(halfd))*(`Weapon Quality`>2?1.2:1))" $$endif
		$$ifdef(max) exp MAX "round(($(max))*(`Weapon Quality`>2?1.2:1))" $$endif
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}


$$macro crossbow(name, st, skill, dmgtype, ss, acc, halfd, max, price, weight, notes, page)
{{
$$macrodesc("Missile weapon macro")
$$argdesc(name, "Name of crossbow")
$$argdesc(st, "Crossbow's ST")
$$argdesc(skill, "List of skill variable names, separated by commas")
$$argdesc(dmgtype, "Damage type (cr, imp)")
$$argdesc(ss, "Snap shot")
$$argdesc(acc, "Accuracy")
$$argdesc(halfd, "Half damage distance")
$$argdesc(max, "Maximum distance")
$$argdesc(price, "Price (in $)")
$$argdesc(weight, "Weight (in lbs)")
$$argdesc(notes, "Additional notes")

	$$item($(name))
	noviolation
	keepcost
	cat "Missile Weapon;Ranged Weapon"
	$$ifdef(notes)
		notes "$(notes)"
	$$endif

	format "%0ln (ST ^o'ST', ^o'Damage'$$if(skill<>''), $$endif$$ifdef(skill)Skill: ^o'Skill'$$endif^x|dquan(`Quantity`,0)|)%-18rx|dp(0)|$(posswtfmt)"
	sformat "%0ln (ST ^o'ST', Acc ^o'Acc'$$showMissDmg(D, $(halfd))$$showMissDmg(MAX, $(max)))$$pricefmt($(price))%-7rx|dew($(weight))|"

	varname "w_$$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")"
	level "$(weight)"
	formula "x$$ifdef(skill)+0*max($(skill))$$endif"
	editdlg 4
	prereq "Main:ST>=7"

	adj "posscost+`Price`"
	totalcostformula "$(equiptcf)"
	size 302 345
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)*(`Weapon Quality`>2?4:1)" noprint end
		$$priceopt($(price))
		begin text "ST" "??$(ST);$(ST);x;x>=7" noprint end
		begin exp "Damage" "format('$(dmgtype) %s', thrustmax(`ST`, 4+`Extra Damage`, 3, 0))" noprint end
		$$ifdef(skill) begin exp Skill "max($(skill))+`Extra Accuracy`" noprint end $$endif
		$$ifdef(acc) text Acc ??$(acc) $$endif
		$$ifdef(ss) text SS ??$(ss) $$endif
		$$ifdef(halfd) exp "Half DMG" "round(($(halfd))*(`Weapon Quality`>2?1.2:1))" $$endif
		$$ifdef(max) exp MAX "round(($(max))*(`Weapon Quality`>2?1.2:1))" $$endif
		exp "Cocking Time" "qindex(`st`-st+1,2,6,6,\"20 (requires Goat's Foot)\")"
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}



# dmg macro arguments:
# damage: The type of damage, the amount and the maximum. The maximum can be omitted. The format
#	should be the following:
# imp thr
# imp thr-2
# imp thr-2
# imp thr-2
# cut sw
# cut thr
# The amount must always be sw or thr.

$$macro dmg(damage, qual, skills)
{{
$$hideMacro()
	$$define sk
	$$ifdef(skills)
		$$scan(skills, "^([a-z0-9]+)$|^([a-z0-9]+)[^a-z0-9]", sk)
	$$endif
	$$ifdef(damage)
begin exp Damage "format('\
$$repeat($(damage), d, " *; *", ", ")\
$$scan(d, "^\"?(.*) (sw|thr)([+-][0-9])?( [0-9]d[-+][0-9])?", type, swthr, adds, maxdmg)\
$$ifnull(type)\
	$$error(Incorrect format in first damage spec)\
$$endif\
$(type) %s\
$$endrepeat\
', \
$$repeat($(damage), d, " *; *", ", ")\
$$scan(d, "^\"?(.*) (sw|thr)([+-][0-9])?( [0-9]d[-+][0-9])?", type, swthr, adds, maxdmg)\
$$ifdef(maxdmg)\
$$scan(maxdmg, "([0-9])d([-+][0-9])", mindice, minadds)\
$(swthr)max($$ifdef(adds)$(adds)+$$endif`Extra Damage`$$ifdef(sk)+ewd($(sk))$$endif$$ifdef(qual)+qindex(`Weapon Quality`,$(qual))$$endif, $(mindice), $(minadds))\
$$else\
$(swthr)($$ifdef(adds)$(adds)+$$endif`Extra Damage`$$ifdef(sk)+ewd($(sk))$$endif$$ifdef(qual)+qindex(`Weapon Quality`,$(qual))$$endif)\
$$endif\
$$endrepeat\
)" noprint end
$$endif
}}

$$macro showdmg(dmg, extra)
{{$$if(dmg<>'' or extra<>'') ($$ifdef(dmg)$$exp("replaceString(dmg,';',', ')")$$ifdef(extra), $$endif$$endif$$ifdef(extra)$(extra)$$endif)$$endif}}

# Display the skill and parry.

$$macro dispSkill(skill, parry)
{{
$$hideMacro()
	$$ifdef(skill)
		begin exp Skill "max($(skill))+`Extra Accuracy`" noprint end
		$$ifdef(parry)
			$$scan(parry, "^(.*)-([0-9])$|^(.*)$", p, ppenalty)
			begin exp Parry "integer((max($(skill))+`Extra Accuracy`)*$(p))+wpbonus(0)$$ifdef(ppenalty)-$(ppenalty)$$endif" noprint end
		$$else
			begin exp Parry "integer((max($(skill))+`Extra Accuracy`)/2)+wpbonus(0)" noprint end
		$$endif
	$$endif
}}

$$macro weapclass(skill)
{{
$$hideMacro()
	$$ifdef(skill)
		$$scan(skill, "^([^,]+)", mainskill)
		$$ifdef(mainskill)
			class "$(mainskill)"
		$$endif
	$$endif
}}

$$macro sword(name, skill, dmg, reach, price, weight, st, notes, parry, page)
{{
$$macrodesc("Sword macro")
$$argdesc(name, "Name of sword")
$$argdesc(skill, "List of skill variable names that can be used, separated by commas")
$$argdesc(dmg, "Damage type: cut sw, imp sw+1, cr sw+3, etc. Separate multiple types with semicolons")
$$argdesc(reach, "Reach of weapon. Delimit reaches corresponding to damage by semicolons")
$$argdesc(price, "Price of weapon (in $)")
$$argdesc(weight, "Weight of weapon in lbs")
$$argdesc(st, "Minimum ST required (optional)")
$$argdesc(notes, "Any descriptive notes (number of hands, etc.)")
$$argdesc(parry, "Parry multiple (optional, default is 1/2. Fencing would be 2/3, knife 1/2-1)")

	$$item($(name))
	noviolation
	keepcost
	cat "Hand Weapon"
	$$ifdef(notes)
		notes "$(notes)"
	$$endif
	$$weapclass($(skill))

	format "%0ln (^o'Damage'$$ifdef(skill), Skill: ^o'Skill', Parry: ^o'Parry'$$endif^x|dquan(`Quantity`,0)|)%-18rx|dp(0)|$(posswtfmt)"
	sformat "%0ln$$showdmg($(dmg))$$pricefmt($(price))%-7rx|dew($(weight))|"

	varname "w_$$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")"
	level "$(weight)"
	formula "x+0*ST$$ifdef(skill)*max($(skill))$$endif"
	editdlg 4

	$$ifdef(st) prereq "Main:ST>=$(st)" $$endif
	editdlg 4
	adj "posscost+`Price`;zparry+1"
	totalcostformula "$(equiptcf)"

	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)*qindex(`Weapon Quality`,1,.4,4,20.)"  noprint end
		$$priceopt($(price))

		$$ifdef(dmg)
			$$dmg($(dmg), "0,0,1,2", $(skill))
		$$endif

		$$ifdef(reach) text Reach "$(reach)" $$endif
		$$ifdef(st) text ST ??$(st) $$endif
		$$dispSkill($(skill), $(parry))
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}


$$macro fsword(name, skill, dmg, reach, price, weight, st, notes, parry)
{{
$$macrodesc("Force sword macro")
$$argdesc(name, "Name of force sword")
$$argdesc(skill, "List of skill variable names that can be used, separated by commas")
$$argdesc(dmg, "Damage type: imp 4d, etc. Separate multiple types with semicolons")
$$argdesc(reach, "Reach of weapon. Delimit reaches corresponding to damage by semicolons")
$$argdesc(price, "Price of weapon (in $)")
$$argdesc(weight, "Weight of weapon in lbs")
$$argdesc(st, "Minimum ST required (optional)")
$$argdesc(notes, "Any descriptive notes (number of hands, etc.)")
$$argdesc(parry, "Parry multiple (optional, default is 1/2. Fencing would be 2/3, knife 1/2-1)")

	$$item($(name))
	noviolation
	keepcost
	cat "Hand Weapon;Force Weapon"
	$$ifdef(notes)
		notes "$(notes)"
	$$endif
	$$weapclass($(skill))

	format "%0ln (^o'Damage'$$ifdef(skill), Skill: ^o'Skill', Parry: ^o'Parry'$$endif^x|dquan(`Quantity`,0)|)%-18rx|dp(0)|$(posswtfmt)"
	sformat "%0ln$$showdmg($(dmg))$$pricefmt($(price))%-7rx|dew($(weight))|"

	$$ifdef(st) prereq "Main:ST>=$(st)" $$endif

	varname "w_$$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")"
	level "$(weight)"
	formula "x+0*ST$$ifdef(skill)*max($(skill))$$endif"
	editdlg 4

	adj "posscost+`Price`;zparry+1"
	totalcostformula "$(equiptcf)"

	cost $(weight)
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)*qindex(`Weapon Quality`,1,.4,4,20.)"  noprint end
		$$priceopt($(price))

		$$ifdef(dmg)
			text Damage "$(dmg)"
		$$endif

		$$ifdef(reach) text Reach "$(reach)" $$endif
		$$ifdef(st) text ST ??$(st) $$endif
		$$dispSkill($(skill), $(parry))
		end
}}

$$macro priceopt(price)
{{
$$hideMacro()
	$$if(strindex(price, ";") > 0)
		begin text "Base Price" "?:1;$(price)" noprint end
	$$else
		begin text "Base Price" "??$$ifnull(price)0$$else$(price)$$endif;$$ifnull(price)0$$else$(price)$$endif;;x>=0" noprint end
	$$endif
}}

$$macro pricefmt(price)
{{$$hidemacro()$$if(strindex(price,';')>0)%-20r!Varies$$elseif(price='')%-20r!--$$else%-20rx|dm($(price))|$$endif}}

# Macro for guns.
# The arguments should be self-explanatory except for skill.
# skill: the skill variable to be used for this weapon, separated by commas. This is
# the same as the skill, excluding any non-alphabetic characters (i.e., Black Powder Weapons
# should be BlackPowderWeapons).

$$macro gun(name, skill, malf, dtype, dmg, ss, acc, halfd, max, weight, rof, shots, st, rcl, price, tl, notes, cat, page)
{{
$$macrodesc("Gun macro")
$$argdesc(name, "Gun name")
$$argdesc(skill, "List of skills for gun")
$$argdesc(malf, "Malfunction number")
$$argdesc(dtype, "Damage type (cr, imp, etc.)")
$$argdesc(dmg, "Damage (4d+2, etc.)")
$$argdesc(ss, "Snapshot")
$$argdesc(acc, "Accuracy")
$$argdesc(halfd, "Half damage distance")
$$argdesc(max, "Maximum distance")
$$argdesc(weight, "Weight (in lbs)")
$$argdesc(rof, "Rate of fire (optional, for example 3~)")
$$argdesc(shots, "Number of shots")
$$argdesc(st, "Minimum ST required")
$$argdesc(rcl, "Recoil penalty")
$$argdesc(price, "Price (in $). To indicate multiple prices, use the form \"Early 1900's,35;Modern,300\"")
$$argdesc(tl, "Minimum TL")
$$argdesc(notes, "Extra notes")
$$argdesc(cat: cat, "Additional categories")

	$$item($(name))
	noviolation
	keepcost
	cat "Gun;Ranged Weapon$$ifdef(cat);$(cat)$$endif"

	format "%0ln (^o'Damage'$$ifdef(skill), Skill: ^o'Skill'$$endif^x|dquan(`Quantity`,0)|)%-18rx|dp(0)|$(posswtfmt)"
	$$define extragunInfo 
	sformat "%0ln ($$ifdef(dtype)$(dtype)$$ifdef(dmg) $(dmg)$$endif$$endif$$ifdef(acc), Acc ^o'Acc'$$endif$$ifdef(halfd), D ^o'Half DMG'$$endif$$ifdef(max), MAX ^o'MAX'$$endif)$$pricefmt($(price))%-7rx|dew($(weight))|"

	$$ifdef(st)
		prereq "Main:ST>=$(st)$$ifdef(tl);Configuration:TL>=$(tl)-&tl$$endif"
	$$else
		$$ifdef(tl)
			prereq "Configuration:TL>=$(tl)-&tl"
		$$endif
	$$endif

	varname "w_$$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")"
	level "$(weight)"
	formula "x$$ifdef(skill)+0*max($(skill))*DX$$endif"
	editdlg 4

	adj "posscost+`Price`"
	totalcostformula "$(equiptcf)"
	$$ifdef(notes) notes "$(notes)" $$endif
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		$$ifdef(malf) text Malfunction "$(malf)" $$endif
		$$ifdef(skill) begin exp Skill "max($(skill)$$if(strindex(skill,'DX-')<=0),dx-4$$endif)+`Extra Accuracy`" noprint end $$endif
		$$ifdef(dtype) begin text Damage "$(dtype)$$ifdef(dmg) $(dmg)$$endif" noprint end $$endif
		$$ifdef(ss) text SS "??$(ss)" $$endif
		$$ifdef(acc) text Acc "??$(acc)" $$endif
		$$ifdef(halfd) text "Half DMG" "??$(halfd)" $$endif
		$$ifdef(max) text MAX "??$(max)" $$endif
		$$ifdef(rof) text RoF "??$(rof)" $$endif
		$$ifdef(shots) text Shots "??$(shots)" $$endif
		$$ifdef(st) text ST "??$(st)" $$endif
		$$ifdef(rcl) text Rcl "??$(rcl)" $$endif
		$$ifdef(tl) text TL "??$(tl)" $$endif
		$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}



$$macro rifle(name, notes, dtype, dmg, ss, acc, halfd, max, weight, rof, shots, st, rcl, price, tl)
{{
$$macrodesc("Gun macro")
$$argdesc(name, "Gun name")
$$argdesc(notes, "Extra notes")
$$argdesc(malf, "Malfunction number")
$$argdesc(dtype, "Damage type (cr, imp, etc.)")
$$argdesc(dmg, "Damage (4d+2, etc.)")
$$argdesc(ss, "Snapshot")
$$argdesc(acc, "Accuracy")
$$argdesc(halfd, "Half damage distance")
$$argdesc(max, "Maximum distance")
$$argdesc(weight, "Weight (in lbs)")
$$argdesc(rof, "Rate of fire (optional, for example 3~)")
$$argdesc(shots, "Number of shots")
$$argdesc(st, "Minimum ST required")
$$argdesc(rcl, "Recoil penalty")
$$argdesc(price, "Price (in $)")
$$argdesc(tl, "Minimum TL")
	$$gun($(name), "GunsRfl,dx-4", , $(dtype), $(dmg), $(ss), $(acc), $(halfd), $(max), $(weight), $(rof), $(shots), $(st), $(rcl), $(price), $(tl), $(notes), Rifle)
}}

# macro for ammo

$$macro ammo(name, weight, price, dmg, dmgMod, rounds, tl)
{{
	$$item($(name))
	noviolation
	keepcost
	cat "Ammunition"
	format "%0ln (DMG ^o'DMG', Dmg Mod. ^o'Damage Mod.'^x|`Quantity`>1?', `Quantity`':''|)%-16rx|dp(0)|$(posswtfmt)"
	sformat "%0ln$$pricefmt($(price))$(posswtfmt)"
	editdlg 4
	adj "posscost+`Price`"
	totalcostformula "$(equiptcf)"
	cost $(weight)

	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)*qindex(`Type`,1,1.5,3)" noprint end
		$$priceopt($(price))
		text Type "?:1;Standard, 1;Hollow-Point, 2;Armor-Piercing, 3"
		exp DMG "format(\"%d\", $(dmg)*qindex(`Type`,1,.5,2))"
		exp "Damage Mod." "format(\"%d\", $(dmgMod)*qindex(`Type`,1,2,.5))"
		$$ifdef(rounds)
			exp Rounds $(rounds)*max(1,`Quantity`)
		$$else		
			exp Rounds 100*max(1,`Quantity`)
		$$endif
		$$ifdef(tl) text TL "??$(tl)" $$endif
		end
}}


$$macro grenade(name, type, dmg, weight, fuse, price, tl, country)
{{
	$$item($(name))
	keepcost
	cat "Grenade;*Ranged Weapon"
	format "%0ln (^o'Damage'^x|`Quantity`>1?', `Quantity`':''|)%-18rx|dp(0)|$(posswtfmt)"
	sformat "%0ln$$showdmg($(dmg))$$ifdef(price)$$pricefmt($(price))$$endif$(posswtfmt)"
	editdlg 4
	adj "posscost+`Price`"
	totalcostformula "$(equiptcf)"
	cost $(weight)
	opt
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		exp Skill "max(Throwing,dx-3)"
		begin text Damage "$(type) $(dmg)" noprint end
		text SS ??12
		exp MAX "round((integer(Throwing/6)+ST)*3.5)"
		text Fuse "$(fuse)"
		$$ifdef(tl) text TL "??$(tl)" $$endif
		$$ifdef(country) text Country "$(country)" $$endif
		end
}}

$$macro animal(name, st, dx, iq, ht, move, price, weight, notes)
{{
	$$item($(name))
	noviolation
	keepcost
	cat "Animals"
	editdlg 4
	cost 0

	format "%0ln (ST ^o'ST', DX ^o'DX', IQ ^o'IQ', HT ^o'HT', Move ^o'Move')^x|`Quantity`>1?' (`Quantity`)':''|%-18rx|dp(0)|%-7rx|dew(`Weight`)|"
	sformat "%0ln$$pricefmt($(price))$$ifdef(weight)%-7rx|dew($(weight))|$$else%-7r!$$endif"
	$$ifdef(notes) notes "$(notes)" $$endif
	adj "posscost+max(1,`Quantity`)*`Base Price`*(`No Cost`=0)"
	totalcostformula c*m+aux
	opt
		$$ifdef(weight)
			begin text Weight "$(weight)" noprint end
		$$endif
		begin exp Price "max(1,`Quantity`)*`Base Price`*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		begin text ST ??$(st) noprint end
		begin text DX ??$(dx) noprint end
		begin text IQ ??$(iq) noprint end
		begin text HT ??$(ht) noprint end
		$$ifdef(move)
			begin text Move $(move) noprint end
		$$else
			begin text Move "(`HT`+`DX`)/4" noprint end
		$$endif
		end
}}


$$macro sublist(name, format, autoitems)
{{
$$macrodesc("Sublist macro")
$$argdesc(name, "Name of sublist")
$$argdesc(format, "Display format (optional, default is name and cost in standard places)")
$$argdesc(autoitems: autoitems, "Items added automatically to list, semicolon-delimited (optional)")

	$$item($(name))
	noviolation
	altformat "Categories" "" "%0ln%-14rc%-7r!"
	$$ifdef(format)
		format "$(format)"
	$$else
		format "%0ln%-14rc%-7r!"
	$$endif
	addaslist
	$$ifdef(autoitems)
		sformat %0ln
		dontmarkauto addwholelist autochargecost
		autoitems "$(autoitems)"
	$$else
		sformat %0ln%-10r!Sublist
	$$endif
}}


$$macro sense(name, varname)
{{
	$$item($(name))
	editdlg 2
	$$ifdef(varname) varname "v_$(varname)" $$endif
	formula "0*$(varname)*IQ"
	level 0
	cat Sense
	adj "$(varname)Sense=$(varname)<-10?0:`Base Value`+$(varname)"
	format "%0ln%-12r!--%-7ro'Level'"
	sformat %0ln%-5ll
	opt begin exp Level "$(varname)<-10?'--':`Base Value`+$(varname)" noprint end
		begin text  "Base Value" "IQ" keepold noprint end
		end
}}

$$macro note(name)
{{
	item "$(name)"
		dupexpected
		cost 0
		cat *Note
		editdlg 1
		format "%0ln"
		sformat "%0ln"
}}



$$macro custAttr(name, formula, varname, checkexp)
{{
$$macrodesc("Custom attribute macro")
$$argdesc(name, "Name of custom attribute")
$$argdesc(formula, "Formula that computes cost of attribute (optional, if omitted, standard Attribute cost structure is used)")
$$argdesc(varname, "Internal variable name for attribute (optional)")
$$argdesc(checkexp, "Check expression (optional, x>0 assumed)")

	item "$(name)"
	noviolation
	level 10
	$$ifdef(checkexp)
		checkexp "$(checkexp)"
	$$else
		checkexp "x>0"
	$$endif
	cat Attribute
	$$ifdef(varname)
		varname "$(varname)"
	$$else
		varname c_attr
	$$endif
	$$ifdef(formula)
		formula "$(formula)"
	$$else
		formula "attCost(~x)"
	$$endif
	format %0ln%-12rc%-7rv
	sformat	%0ln
	adj "addAttCost+attExpCost(x,`Starting Level`,0)$$ifnull(varname);`Internal Name`+x$$endif"
	$$ifnull(varname)
		opt	
			begin text "Internal Name" "Attribute"
				checkexp "strindex('`Internal Name`', ' ') <= 0;Blanks not allowed in Internal Name"
				noprint
				end
			end
	$$endif
}}



$$macro deriv(name, formula, exp, intname)
{{
$$macrodesc("Derived attribute macro")
$$argdesc(name, "Name of derived attribute")
$$argdesc(formula, "Formula that references all the variables that this attribute depends on")
$$argdesc(exp, "Expression that produces the actual value of attribute (e.g., iq+will)")
$$argdesc(intname, "Internal name to be used for variable")

	item "$(name)"
		$$ifdef(formula)
			formula "$(formula)"
		$$else
			formula attributes*0
		$$endif
		$$ifdef(intname)
			varname $$exp("replaceString(intname, \"/[^a-zA-Z]/\", '')")
		$$else
			varname derivChar
		$$endif

		cat "Derived"

		sformat "%0ln"
		editdlg 3
		format "%0ln%-12r!--%-7rv"
		$$ifdef(exp)
			checkexp "x=($(exp))"
			level "$(exp)"
		$$else
			checkexp "x=optValue('Value')"
			level 0
			opt	
				begin exp Value "0" noprint keepold end
				end
		$$endif
}}


$$macro infostat(name, formula, exp, varname)
{{
$$macrodesc("Information statistic macro (such as Broadjump)")
$$argdesc(name, "Name of statistic")
$$argdesc(formula, "Formula used to detect changes (should evaluate to zero)")
$$argdesc(exp, "Expression that computes actual value")
$$argdesc(varname, "Variable name (optional, default is name with non-alpha characters removed)")

	item "$(name)"
	$$ifdef(formula)
		formula "$(formula)"
	$$else
		formula attributes*0
	$$endif
	$$ifdef(varname)
		varname "$(varname)"
	$$else
		varname $$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")
	$$endif
	cat "Information"

	level 0
	sformat "%0ln"
	format "%0ln: ^o'Value'%-12r!--%-7r!"
	editdlg 2
	opt	
		begin exp Value "$(exp)" noprint end
		end
}}



$$macro reqroll(text)
{{
	opt	text Roll "$(text)"
		end
}}



$$macro race(name, cost, adj, reactions, adv, disadv, skills, quirks, prereq, powers, spells, addatt, datasheets, cat, format, sformat)
{{
$$macrodesc("Race macro")
$$argdesc(name, "Name of race")
$$argdesc(cost, "Point cost of race")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(reactions, "Racial reaction adjustments")
$$argdesc(adv: autoitems, "Automatic items: advantages granted, separated by semicolons")
$$argdesc(disadv: autoitems, "Automatic items: disadvanges required, separated by semicolons")
$$argdesc(skills: autoitems, "Automatic items: skills granted")
$$argdesc(quirks: autoitems, "Racial quirks")
$$argdesc(prereq: req, "Prerequisites")
$$argdesc(powers: autoitems, "Powers")
$$argdesc(spells: autoitems, "Spells")
$$argdesc(addat, "Additional Attributes")
$$argdesc(datasheets, "Comma-separated list of additional data sheets")
$$argdesc(cat, "Additional categories")
$$argdesc(format, "Format string (optional, default is ^n)")
$$argdesc(sformat, "Selection format string (option, default is ^n)")

	$$item($(name))
	noviolation
	cat "Race$$ifdef(cat);$(cat)$$endif"
	prereq "!#1,Adv:Race$$ifdef(prereq)~$(prereq)$$endif"
	script "setRaceAtt();"
	$$ifdef(AddRaceAsList)
		$$ifdef(format)
			format "%0l!$(format)%-12rc%-7r!"
		$$else
			format "%0ln%-12rc%-7r!"
		$$endif
		addaslist
	$$else
		$$ifdef(format)
			format "%0l!$(format)%-12r!%-7r!"
		$$else
			format "%0ln%-12r!%-7r!"
		$$endif
	$$endif
	$$ifdef(sformat)
		sformat "%0l!$(sformat)%-7r!$(cost)"
	$$else
		sformat "%0ln%-7r!$(cost)"
	$$endif
	editdlg 5
	dontmarkauto autochargecost deleteauto noautodup
	autoitems "$$ifdef(datasheets)$$repeat($(datasheets), ds, ' *, *')?datasheet:$(ds);$$endrepeat$$endif\
$$ifdef(adv)?list:Advantages;?cat:Advantages;$(adv)$$endif\
$$ifdef(addatt);?clear;$$ifnull(AddRaceAsList)?list:Additional Attributes;$$endif?cat:Additional Attributes;$(addatt)$$endif\
$$ifdef(powers);?clear;$$ifnull(AddRaceAsList)?list:Powers;$$endif?cat:Powers;$(powers)$$endif\
$$ifdef(disadv);?clear;$$ifnull(AddRaceAsList)?list:Disadvantages;$$endif?cat:Disadvantages;?ncopt:Racial Disadvantage;$(disadv)$$endif\
$$ifdef(quirks);?clear;$$ifnull(AddRaceAsList)?list:Quirks;$$endif?cat:Quirks;?opt:Racial Quirk;$(quirks)$$endif\
$$ifdef(skills);?clear;?charge;?list:Skills;?cat:Skills;$(skills)$$endif\
$$ifdef(spells);?clear;?charge;?list:Spells;?cat:Spells;?noreq;$(spells)$$endif"

	$$ifdef(adj) adj "$(adj)" $$endif
	$$ifdef(reactions)
		opt
			text Reaction "$(reactions)"
			end
	$$endif
}}




$$macro martman(name, diff, def, prereq, max, dmg, catref, parry, fmt, cat)
{{
$$macrodesc("Martial maneuver macro")
$$argdesc(name, "Name of maneuver")
$$argdesc(diff: mmdiff, "Difficulty (\"Hard\" or \"Avg\")")
$$argdesc(def, "Default value")
$$argdesc(prereq: req, "Prerequisite for maneuver.")
$$argdesc(max, "Maximum value (omit if none).")
$$argdesc(dmg, "Damage type (i.e., sw+1, thr-2).")
$$argdesc(catref, "Item reference category. Maneuvers that are based on a skill should specify the category of item (usually Combat/Weapon).")
$$argdesc(cat: cat, "Additional categories.")

	$$item($(name))
	noviolation
	cat "Martial Arts Maneuver$$ifdef(cat);$(cat)$$endif"
	level "(($(def))+1)"
	varname $$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")
	$$if(diff = "Avg")
		formula "mmcost(x,$(def),0)$$ifdef(dmg)+0*ST$$endif"
		$$ifdef(max)
			checkexp "mmchk(x,c,0,$(def),$(max))"
		$$else
			checkexp "mmchk(x,c,0,$(def),0)"
		$$endif
	$$else
		$$if(diff = "Hard")
			formula "mmcost(x,$(def),1)$$ifdef(dmg)+0*ST$$endif"
			$$ifdef(max)
				checkexp "mmchk(x,c,1,$(def),$(max))"
			$$else
				checkexp "mmchk(x,c,1, $(def),0)"
			$$endif
		$$else
			$$if(diff = "Spec")
				# A special maneuver is only at default.
				usedefault 1
				checkexp "x=($(def))"
			$$else
				$$error(Martial maneuver difficulty must be Hard or Avg or Spec)
			$$endif
		$$endif
	$$endif

	totalcostformula "max(`Minimum Cost`,(c+a)*m)"

	default "$(def)"
	$$ifdef(parry) adj "zparry+1" $$endif

	class "$(diff)"
	$$ifdef(prereq) prereq "$(prereq)" $$endif

	$$ifdef(fmt)
		format "%0l!$(fmt)$$ifdef(dmg) (^o'Damage')$$endif%-18ll%-12rc%-7rv"
	$$else
		format "%0ln$$ifdef(catref) (^x|optTextValue('Skill Reference')|)$$endif$$ifdef(dmg) (^o'Damage')$$endif%-18ll%-12rc%-7rv"
	$$endif
	sformat %0ln%-5ll
	opt
		$$ifdef(dmg)
			$$scan(dmg, "^(sw|thr)([+-].+)$|^(sw|thr)$", type, bonus)
			$$ifnull(type)
				$$error(Maneuver damage formatted incorrectly)
			$$endif
			begin exp Damage "$(type)($$ifdef(bonus)$(bonus)$$else 0$$endif)" noprint end
		$$endif
		$$ifdef(catref)
			begin text "Skill Reference" "?!@v@"
				itemrefcat "$(catref)" noprint
				end
		$$endif
		$$ifdef(parry)
			exp Parry "$(parry)"
		$$endif
		end
}}


$$macro elixir(name, purpose, cat, matcost, time, skill, cost)
{{
$$macrodesc("Elixir skill")
$$argdesc(name, "Name of skill")
$$argdesc(purpose, "Purpose of elixir")
$$argdesc(cat: cat, "Category (Animal Control, etc.)")
$$argdesc(matcost, "Material cost")
$$argdesc(time, "Time to create (e.g, 4 wks)")
$$argdesc(skill, "Skill penalty")
$$argdesc(cost, "Cost to create elixir")

	$$item($(name))
	cat "Elixir;$$ifdef(cat)$(cat) Elixir$$endif"
	varname "elixir_$$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")"
	prereq "Alchemy;$countItems('Skills:Elixir', 0, 0, 'cost')<=Alchemy::$format('May be expert in only %d elixirs',alchemy)"
	formula 0*alchemy
	level 0
	editdlg 2
	class "$$ifdef(skill)$(skill)$$else--$$endif"

	sformat "%0ln (^o'Elixir of')"
	format "%0ln%-18lx|`Skill Penalty`?`Skill Penalty`:'--'|%-12r!--%-7ro'Skill'"
	noviolation
	opt
		$$ifdef(purpose) begin text "Elixir of" "$(purpose)" noprint keepold end $$endif
		$$ifdef(matcost) begin text "Material Cost" "$(matcost)" keepold end $$endif
		$$ifdef(time) begin text Time "??$(time)" keepold end $$endif
		begin text "Skill Penalty" "??$$ifnull(skill)0$$else$(skill)$$endif" noprint keepold end
		begin exp Skill "Alchemy+(`Skill Penalty`?`Skill Penalty`:0)" noprint end
		$$ifdef(cost) begin text Cost "$(cost)" keepold end $$endif
		end
}}


$$macro elix(name, purpose, cat, matcost, time, skill, cost, form)
{{
$$macrodesc("Elixir")
$$argdesc(name, "Name of elixir")
$$argdesc(purpose, "Purpose of elixir")
$$argdesc(cat: cat, "Category (Animal Control, etc.)")
$$argdesc(matcost, "Material cost")
$$argdesc(time, "Time to create (e.g, 4 wks)")
$$argdesc(skill, "Skill penalty")
$$argdesc(cost, "Cost to create elixir")
$$argdesc(form, "Semicolon-delimited list of possible forms (e.g., Potion;Powder)")

	$$item($(name))
	cat "Elixir;$$ifdef(cat)$(cat) Elixir$$endif"
	noviolation dupexpected
	editdlg 4
	level 0
	formula 0*magicRarity
	varname e_elixir
	format "%0ln (^o'Form'^x|dquan(`Quantity`,0)|)%-18rx|dp(0)|$(posswtfmt)"
	$$scan(cost, "\\$([0-9]+)/\\$([0-9]+)|(.+)", price, price2)
	sformat "%0ln (^o'Elixir of')$$pricefmt($(price))$(posswtfmt)"

	adj "posscost+`Price`"
	totalcostformula "$(equiptcf)"
	opt
		begin text "Elixir of" "$(purpose)" noprint end
		begin text Form "?:1;$$ifnull(form)Potion;Powder;Pastille;Unguent$$else$(form)$$endif" noprint end
		begin text "Self-Made" "?+0;" noprint dispexp 'l' end
		begin exp Price "max(1,`Quantity`)*(`Self-Made`?`Material Cost`:qindex(magicRarity+1,`Common Price`,`Rare Price`)*(optValue('Form')='Pastille'?2:1)))" noprint end
		begin text "Material Cost" "$$exp("replaceString(matcost, '/[^0-9]/', '')")" noprint end
		begin text "Common Price" "??$(price);$(price);x;x>=0" noprint end
		begin text "Rare Price" "??$(price2);$(price2);x;x>=0" noprint end
		end
}}

$$macro see(name, format, sublist, realItem)
{{
$$macrodesc("Creates a 'reference' to another item")
$$argdesc(name, "The name of the item. The reference item will actually have !! after this name to avoid having two items with the same name")
$$argdesc(format, "Extra formatting information that will be placed after the name (optional).")
$$argdesc(sublist, "If present, the name of a sublist which will be opened if this item is selected.")
$$argdesc(realItem, "If present, the actual name of the item to be referenced. If omitted, the other item is assumed to have the name specified.")

	$$ifdef(sublist)
		item "$(name): See $(sublist)"
		see cat "$(sublist)"
		sformat %0ln
	$$else
		$$ifdef(realItem)
			item "$(name): See $(realItem)"
			sformat "%0ln"
			see prereq "$(realItem)"
		$$else
			item "$(name)!!"
			$$ifdef(format)
				sformat "%0l!$(name)$(format)"
			$$else
				sformat "%0l!$(name)"
			$$endif
			see prereq "$(name)"
		$$endif
	$$endif
	rand -1
}}


$$macro seespell(name, colleges)
{{
$$macrodesc("A reference to another spell in another college/sublist.")
$$argdesc(name, "The name of the spell. A '*' after the name indicates a Very Hard spell.")
$$argdesc(colleges: colleges, "Comma-separated list of other colleges the spell occurs in (optional).")

	$$scan(name, "^(.+)(\\*)$|^(.+)$", nm, vh)
	item "$(name)!!"
	sformat "%0l!$(nm)$(vh)$$ifdef(colleges) [$(colleges)]$$endif$$ifdef(vh)%-5l!VH$$endif"
	see prereq "$(nm)"
}}

$$macro raceAttrBonus(name, attr, formula, adj) {{
	item "$(name)"
	dsid "$(PLUGIN)"
	format "%0ln%-14rc%-7rx|format('%+d',@v@)|"
	sformat %0ln%-10r!Variable
	totalcostformula $(supcostform)
	adj "$(attr)+x;$$ifdef(adj)$(adj)$$endif"

	level 0
	$$ifdef(formula)
		formula "$(formula)"
	$$else
		formula "attCost(itemInfo('`Base`')+x)-attCost(itemInfo('`Base`'))"
	$$endif
	opt
		begin text Base "??10" noprint end
		end
}}


$$macro natatt(name, type, attr, lc, range, area, duration, damage, dmgtype, prereq, cheap)
{{
$$macrodesc("Natural attack macro")
$$argdesc(name, "Name of attack")
$$argdesc(type, "Type of attack: missle, area, range, etc. (optional)")
$$argdesc(attr, "Base attribute (optional, omit if none)")
$$argdesc(lc, "Cost per level")
$$argdesc(range, "Base range")
$$argdesc(area, "Base area (e.g., 3 hexes)")
$$argdesc(duration, "Duration")
$$argdesc(damage, "Damage (e.g., 1d, 2d-1, etc. Optional)")
$$argdesc(dmgtype, "Damage type (imp, fire, electrical, etc. Optional)")
$$argdesc(prereq: req, "Prerequisites")
$$argdesc(cheap, "Enter 1 if cheap improvement scheme, otherwise leave empty.")

	item "$(name)"
	original "$(PLUGIN) NA $(name)"
	cat "Natural Attack"
	$$ifdef(prereq) prereq "$(prereq)" $$endif

	$$ifdef(attr)
		level "max(12,$(attr))"
		formula "iteminfo('`LC`')+(~x<=12?0:(~x-$(attr))*(iteminfo('`Cheap Improvement Scheme`')?4:iteminfo('`LC`')))"
		checkexp "x>=max(12,$(attr))"
		format "%0ln%-14rc%-7rv"
	$$else
		cost "$(lc)"
		editdlg 4
		keepcost
		format "%0ln%-14rc%-7r! "
	$$endif

	class "$(type)"
	sformat "%0ln ($(type)$$ifdef(attr), $(attr)$$endif)%-5r!$(lc)"

	varname $$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")
	totalcostformula "tcfunc(c+aux,a,@mo@,@p@)"

	opt
		begin text LC "??$(lc);$(lc);x;x>0" noprint end
		$$ifdef(range) 
			begin 
				add "Range" "??1;0;(x-1)*(`Cheap Improvement Scheme`?6:`LC`);x>0"
				dispexp "format('l: %d hexes, +o', t*$(range))"
				end
		$$endif
		$$ifdef(area)
			$$scan(area, "^([0-9]+)(.*)$", num, unit)
			$$ifnull(unit)
				$$error("Unit missing from area in natatt macro")
			$$endif
			begin add "Area" "??1;0;(x-1)*(`Cheap Improvement Scheme`?6:`LC`);x>0"
				dispexp "format('l: %d$(unit), +o', t*$(num))"
				end
		$$endif
		$$ifdef(duration)
			$$if(strindex(duration, "/^[0-9]/"))
				$$scan(duration, "^([0-9]+)(.*)$", num, unit)
				$$ifnull(unit)
					$$error("Unit missing from duration in natatt macro")
				$$endif
				begin add "Duration" "??1;0;(x-1)*(`Cheap Improvement Scheme`?6:`LC`);x>0"
					dispexp "format('l: %d$(unit), +o', t*$(num))"
					end
			$$else
				text "Duration" "$(duration)"
			$$endif
		$$endif
		$$if(strindex(damage, '/') > 0)
			$$repeat($(damage), d, ' */ *')
				$$scan(d, "(.+) +([.1-9]+)d([-+]?[.0-9]+)?", dtype, dice, adds)
				$$ifnull(dice)
					$$error(Bad damage format in natatt macro. Allowable forms: cr 1d-1/imp 1d/knockback 1d+1)
				$$endif
				$$ifnull(adds)
					$$define adds 0
				$$endif
				exp "Damage" "format('$(dtype) %s',diceadds(integer($(dice)*optTextValue('Damage Dice')), integer($(dice)*optTextValue('Damage Dice')*$(adds)), 0, 0, 0))"
			$$endrepeat
		$$else
			$$ifdef (damage) 
				$$scan(damage, "([1-9])d([-+]?[0-9])?", dice, adds)
				$$ifnull(dice)
					$$error(Bad damage format in natatt macro. Allowable forms: 1d-1, 1d, 1d+1)
				$$endif
				$$ifnull(adds)
					$$define adds 0
				$$endif
				exp "Damage" "format('`Damage Type` %s',diceadds(integer($(dice)*optTextValue('Damage Dice')), integer($(dice)*optTextValue('Damage Dice')*$(adds)), 0, 0, 0))"
			$$endif
			$$ifdef (dmgtype) begin text "Damage Type" $(dmgtype) noprint end $$endif
		$$endif
		begin add "Damage Dice" "??1;0;(x-1)*(`Cheap Improvement Scheme`?6:`LC`);x>0" noprint end
		begin text "Cheap Improvement Scheme" "?+$$ifnull(cheap)0$$else$(cheap)$$endif;" dispexp 'l' noprint end
		end
}}


$$macro EnhAttr(name, formula)
{{
	$$item($(name))
	cat "Super Equipment"
	level 10
	$$ifdef(formula)
		formula attcost(x)
	$$else
		formula stcost(x)
	$$endif
	checkexp x>0
	format %0ln%-12rc%-7rv
	sformat %0ln%-10r!Variable
}}


$$macro enhlim(name, value, noprint)
{{
	opt
		$$ifdef(noprint) begin $$endif
		percent "$(name)"
		$$if(strindex(value,";"))
			"?:1;$(value)"
		$$else
			"$(value)"
		$$endif
		$$ifdef(noprint) noprint end $$endif
		end
}}



$$macro psivar(name)
{{$$hideMacro()$$exp("concat('PSI_', replaceString(name, '/[^a-zA-Z]/', ''))")}}


$$macro psipower(name, cost, basepower, skills, adj, autoitems)
{{
$$macrodesc("Psionic power macro")
$$argdesc(name, "Name of power")
$$argdesc(cost, "Cost per level")
$$argdesc(basepower, "Name of base power (optional, omit for base powers like Telepathy)")
$$argdesc(skills: autoitems, "Skills that should be added automatically, separated by semicolons (e.g., Neutralize=0;Psi Static=0)")
$$argdesc(adj: adj, "Adjustments (optional)")
$$argdesc(autoitems: autoitems, "Automatic items (optional)")

	$$item($(name))
	cat "Psionics$$ifdef(basepower);$(basepower)$$endif"
	level 1
	$$ifnull(cost)
		$$error(Psionic power must have a level cost)
	$$endif
	$$ifdef(adj) adj "$(adj)" $$endif

	autochargecost dontmarkauto deleteauto noautodup
	$$ifdef(basepower)
		prereq "!Powers:$(basepower)"
		autoitems "?cat:Skills;?list:Skills;$(name)$$ifdef(autoitems);?clear;$(autoitems)$$endif"
	$$else
		prereq "!#1,Powers:$(name)"
		$$ifdef(skills)
			autoitems "?cat:Skills;?list:Skills;$(skills)$$ifdef(autoitems);?clear;$(autoitems)$$endif"
		$$endif
	$$endif

	formula "~x*$(cost)"
	varname $$psivar($(name))
	$$ifdef(basepower)
		default $$psivar($(basepower))
	$$endif
	checkexp "x>0 and x>=&x"
	format "%0ln%-12rc%-7rx'displev(@v@)'"
	sformat "%0ln%-15r!$$ifdef(basepower)*$$endif$(cost)/level"
	totalcostformula "tcfunc(c,a,@mo@,@p@)"
}}


# psiopt: Psionic option.
# name: The name of the option.
# value: The value. If it starts with a '$' it is assumed to be an expression
# and an expression option will be added (throwing away the $). Otherwise it's
# assumed to be a text option.

$$macro psiopt(name, value)
{{
$$hideMacro()
	$$ifdef(value)
		$$if(strindex(value, "$") = 1)
			exp "$(name)" "$$exp("substr(value,2,strlen(value)-1)")"
		$$else
			text "$(name)" "$(value)"
		$$endif
	$$endif
}}


$$macro psisk(name, oneskillcost, power, prereq, fatigue, range, area, mnt, resist, page)
{{
$$macrodesc("Psionic skill")
$$argdesc(name, "Name of skill")
$$argdesc(oneskillcost, "The cost of the power if it's the only skill in that power")
$$argdesc(power, "Name of the skill's power")
$$argdesc(prereq: req, "Additional prerequisites (above the power)")
$$argdesc(fatigue, "Fatigue (omit if none)")
$$argdesc(range, "Range expression. Use $dtprange(`Power`) to indicate teleport range.")
$$argdesc(area, "Area of effect expression")
$$argdesc(mnt, "Fatigue to maintain")
$$argdesc(resist, "Resistance roll")
$$argdesc(page, "Page in book")

	$$item($(name))
	cat "Psionic"
	class "MH"
	$$ifnull(power)
		error(Power missing from psi skill macro)
	$$endif
	varname $$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")
	formula "x=0?0:MH(~x,IQ)"
	checkexp "x=0 or x>=iq-3+&x"
	level iq-4

	totalcostformula "ceil(max((a+aux)*m,(a+aux)/4))+(round(2*max(c*m,c/4))/2)"

	format "%0ln%-18ll%-12rc%-7rx|dsk(@v@)|"
	sformat %0ln%-5ll

	$$ifnull(oneskillcost)
		$$ifnull(power)
			$$error(No power defined for no one-skill cost)
		$$endif
		prereq "Powers:$(power)$$ifdef(prereq);$(prereq)$$endif"
	$$else
		prereq "Powers:$(power)$$ifdef(prereq);$(prereq)$$endif|Powers:$(name)$$ifdef(prereq);$(prereq)$$endif"
	$$endif

	opt
		$$ifdef(oneskillcost) 
			begin exp Power max($$psivar($(power)),$$psivar($(name)))  noprint end
		$$else 
			begin exp Power $$psivar($(power)) noprint end
		$$endif

		$$ifdef(fatigue) text Fatigue "$(fatigue)" $$endif
		$$psiopt(Range, $(range))
		$$psiopt(Area, $(area))
		$$psiopt(Maintain, $(mnt))
		$$ifdef(resist) text Resist "$(resist)" $$endif
		$$ifdef(page) text Page "P$(page)" $$endif
		end
}}

# Gadget macro.
# Values as in book.

$$macro gadget(name, weight, cost, lc, comp, tl, page, note)
{{
$$macrodesc("Psionic gadget")
$$argdesc(name, "Name of gadget")
$$argdesc(weight, "Weight")
$$argdesc(cost, "Price")
$$argdesc(lc, "Legality Class")
$$argdesc(comp, "Complexity")
$$argdesc(tl, "Tech Level")
$$argdesc(page, "Page in book")
$$argdesc(note, "Any notes")

	$$equip($(name), $(weight), $(cost), Psionic, $(note))
	$$ifdef(tl)
		prereq "Configuration:TL>=$(tl)-&tl"
	$$endif
	opt
		text LC "$(lc)"
		text Complexity "$(comp)"
		text TL "??$(tl)"
		$$ifdef(page) text Page "P$(page)" $$endif
		end
	
}}

# Drug macro. Values as in book.

$$macro drug(name, cost, TL, LC, comp, form, page)
{{
$$macrodesc("Psionic drug")
$$argdesc(name, "Name of drug")
$$argdesc(cost, "Cost")
$$argdesc(TL, "Tech Level")
$$argdesc(LC, "Legality Class")
$$argdesc(Form, "Form")
$$argdesc(page, "Page in book")
	$$gadget($(name), , $(cost), $(LC), $(comp), $(TL), $(page))
	$$ifdef(form) opt text "Form" "$(form)" end $$endif
}}



# Rune macro is for runestones, which can give a bonus to
# skill level.

$$macro rune(name, price)
{{
$$macrodesc("Rune")
$$argdesc(name, "Name of rune")
$$argdesc(price, "Price of rune")

	item "True $(name) Runestone"
	original "$(PLUGIN) $(name)"
	cat "Runestone"
	editdlg 4
	cost 0.01
	format $(possformat)
	sformat "%0ln$$pricefmt($(price))$(posswtfmt)"
	adj "posscost+max(1,`Quantity`)*(`Base Price`+`Skill Bonus`)*(`No Cost`=0);Rune$$exp("replaceString(name, \"/[^a-zA-Z]/\", '')")+qindex(`Skill Bonus`/1000+1,0,1,2)"
	totalcostformula "$(equiptcf)"
	opt 
		begin exp Price "max(1,`Quantity`)*(`Base Price`+`Skill Bonus`)*(`No Cost`=0)" noprint end
		$$priceopt($(price))
		begin text "Skill Bonus" "?:1;None,0;+1,1000;+2,5000" noprint end
		end 
}}

$$macro extramoney(name)
{{
	$$item($(name))
	level 1
	formula x
	sformat "%0ln%-20r!1/month's income"
	format "%0ln (^o'Total')%-14rc%-7rv"
	adj "availMoney+x*`Monthly Income`"
	opt
		begin text "Monthly Income" "??100;100;x;x>=0" dispexp "format('l: %s', dm(o))" end
		begin exp "Total" "dm(`Monthly Income`*x)" noprint end
		end
}}


$$macro timeuse(name) {{
$$macrodesc("Time use macro")
$$argdesc(name, "Name of time use profile")

	$$item($(name))
	cat "Time Use"
	format %0ln
	sformat %0ln
	level 0
	formula 0*laziness
	totalcostformula 0
	editdlg 2
	size 302 400
	opt
		begin exp "Total Hours" "iteminfo('@a@')+`Sleep`" dispexp "format('l: o/%d',(daysPerWeek?daysPerWeek:7)*(hoursPerDay?hoursPerDay:24))" end
		begin exp Sleep "((listiteminfo('Disadvantages', 'Laziness', '@c@')?10:8)+ExtraSleep-LessSleep)*(daysPerWeek?daysPerWeek:7)" end
		add "Meals, Personal Care, etc." ??20;20;x;x>=0
		add Job ??40;40;x;x>=0
		add Travel ??0;0;x;x>=0
		add "Religious Observances" ??0;0;x;x>=0
		add Entertainment ??0;0;x;x>=0
		begin add "Study Skill" "??Hours per Week;Hours per Week;x;x>=0" qual Skill end
		end
}}


$$macro job(name, wealth, req, salary, success, failure, col, formula) {{
$$macrodesc("Job macro")
$$argdesc(name, "Name of job")
$$argdesc(wealth, "Wealth level: 1, Poor; 2, Struggling; 3, Average; 4, Comfortable; 5, Wealthy")
$$argdesc(req: req, "Requirements for the job (optional)")
$$argdesc(salary, "Monthly salary expression (may be constant or expression such as \"merchant*80\" (optional)")
$$argdesc(success, "Expression for success roll (e.g., \"IQ-1\")")
$$argdesc(failure, "Critical failure outcome. Values after slash indicate result for 18. E.g.: -2i,-3d/-3i,-5d,LJ,lose equipment")
$$argdesc(col, "Cost of living (optional)")
$$argdesc(formula, "Formula for detecting changes to dependent variables (optional).")

	$$scan(name, "^([^*]+)(\\*?)", nm, freelance)
	$$item($(nm))
	cat "Job"
	class "$(Wealth)"
	format "%0ln"
	sformat "%0ln$(freelance)$$ifdef(wealth)%-13lo'Wealth Level'$$endif"
	$$ifdef(req)
		prereq "$$if(wealth=5)!Disadv:Poverty>1::May not be poor~$$endif$(req)"
	$$else
		$$if(wealth=5)
			prereq "!Disadv:Poverty>1"
		$$endif
	$$endif
	$$ifdef(formula)
		level 0
		formula "0*($(formula))"
		varname "Job_$$exp("replaceString(name, '/[^A-Za-z0-9]/', '')")"
	$$endif
	editdlg 2
	opt
		$$ifdef(wealth)
			text "Wealth Level" "?:$(wealth);Poor;Struggling;Average;Comfortable;Wealthy"
			begin exp Salary "jobmult($$ifnull(salary)0$$else$(salary)$$endif)" dispexp "format('l: %s', dm(o))" keepold end
		$$else
			begin exp Salary "$(salary)" dispexp "format('l: %s', dm(o))" keepold end
		$$endif
		$$ifdef(freelance) begin text Freelance "?+1;" dispexp 'l' end $$endif
		$$ifdef(col) begin adj "Cost of Living" "costOfLiving+x" "$(col)" dispexp "format('l: %s', dm(o))" end $$endif
		$$ifdef(success) begin exp Success "$(success)" keepold end $$endif
		$$ifdef(failure) begin text Failure "$(Failure)" keepold end $$endif
		end
}}



$$macro costofLiving(name, cost)
{{
$$macrodesc("Cost of living macro")
$$argdesc(name, "Name")
$$argdesc(cost, "Cost per month")

	$$item($(name))
	cat "Cost of Living"
	format "%0ln: ^x|dm(@v@)|/month"
	sformat %0ln
	formula x*0
	adj "costOfLiving+x"
	editdlg 3
	opt
		begin text "Omit on Control Sheet" "?+1;" noprint dispexp "'l'" end
		end
}}



$$macro devhist(name, fmt, cat)
{{
$$macrodesc("Development history")
$$argdesc(name, "Name of history entry")
$$argdesc(fmt, "Format specification")
$$argdesc(cat, "Additional categories")

	$$item($(name))
	editdlg 5
	dupexpected
	cat "History$$ifdef(cat);$(cat)$$endif"
	format "%0ln: $$ifdef(fmt)$(fmt)$$else^o'Result'$$endif"
	sformat %0ln
	opt
		text Year ??0;0;x;x>=0
		text Week "??1;1;x;x>0"
		begin text Result "Result" keepold end
		end
}}


$$macro spCollege(name)
{{
$$macrodesc("Spell college skill")
$$argdesc(name, "Name of college")
	item "$(name) College"
	dsid "MCol"
	cat "College Skill"
	format "%0ln%-7ro'Level'"
	sformat "%0ln"
	formula "0*spells"
	level 0
	varname "$$exp("replaceString(name, '/[^a-zA-Z]/', '')")College"
	editdlg 2
	opt
		begin exp Level "collegeSkill('$(name)')" noprint end
		end
}}


$$macro MinAtt(name, value)
{{
$$macrodesc("Minimum attribute value")
$$argdesc(name, "Name of attribute (IQ, ST, DX, HT)")
$$argdesc(value, "Minimum value")
	$$item("Minimum $(name)")
	cat "Minimum $(name);Attribute Limit"
	prereq "!#1,Advantages:Minimum $(name);!#1,Advantages:Attribute Limits"
	format "%0ln%-14r!--%-7rv"
	sformat %ln
	formula 0
	editdlg 3
	level "$(value)"
	adj "min$(name)+x"
	checkexp "x>=0 and (max$(name) = 0 or x<=max$(name))"
}}



$$macro MaxAtt(name, value)
{{
$$macrodesc("Maximum attribute value")
$$argdesc(name: attribute, "Name of attribute (IQ, ST, DX, HT)")
$$argdesc(value, "Maximum value")
	$$item("Maximum $(name)")
	cat "Maximum $(name);Attribute Limit"
	prereq "!#1,Advantages:Maximum $(name);!#1,Advantages:Attribute Limits"
	format "%0ln%-14r!--%-7rv"
	sformat %ln
	formula 0
	editdlg 3
	level "$(value)"
	adj "max$(name)+x"
	checkexp "x>=0 and x>=min$(name)"
}}


$$macro genericskill(name, costMult, cat, default, format)
{{
	$$item($(name))
	$$ifdef(cat) cat "$(cat)" $$endif
	noviolation
	dupexpected
	format "%0l!$$ifdef(format)$(format)$$else^n$$endif^x|doptlist('Specialty')|^x|optPresent('TL')?format('/TL%d',`TL`):''|%-18lo'Difficulty'%-12rc%-7rv"
	sformat "%0ln%-10r!Varies"
	varname "genericSkill"
	formula "genSkCost(~x)$$ifdef(costMult)*$(costMult)$$endif"
	checkexp "skchk(x,c)"
	level iq-2
	defbaseable
	default "bv(v,x);`Default`"
	defFormula "genSkCost(~x)+0*skills"
	opt
		begin text Specialty "" noprint keepold end
		begin text "Difficulty" "?:2;ME;MA;MH;MVH;PE;PA;PH" noprint end
		begin text "Base Attribute" "?:1;Normal;ST;DX;IQ;HT" noprint end
		begin text "Affected by Eidetic Memory" "?+0;" dispexp 'l' noprint end
		begin text Default "$$ifdef(default)$(default)$$endif" noprint keepold end
		end
}}


$$macro racialreq(name, cat, req)
{{
	$$item($(name))
	$$ifdef(req)
		prereq "$(req)"
	$$endif
	dupexpected
	cat "$$ifnull(cat)Racial Requirements$$else$(cat)$$endif$$ifdef(req);Reference$$else;Definition$$endif"
	format "%0ln" sformat %0ln
	editdlg 5
}}
